/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.order;

import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.app.DefaultContextSwitchListener;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryBrowser;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.workspace.CRUDWindow;
import org.openvpms.web.component.workspace.ResultSetCRUDWorkspace;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerSummary;
import org.openvpms.web.workspace.patient.summary.CustomerPatientSummaryFactory;
import org.openvpms.web.workspace.workflow.order.CustomerOrderCRUDWindow;
import org.openvpms.web.workspace.workflow.order.CustomerOrderQuery;

public class CustomerOrderWorkspace
extends ResultSetCRUDWorkspace<FinancialAct> {
    private final Preferences preferences;
    private static final String[] SHORT_NAMES = new String[]{"act.customerOrder*", "act.customerReturn*"};

    public CustomerOrderWorkspace(Context context, MailContext mailContext, Preferences preferences) {
        super("workflow.order", context);
        this.preferences = preferences;
        this.setArchetypes(Archetypes.create((String[])SHORT_NAMES, FinancialAct.class, (String)Messages.get((String)"workflow.order.type")));
        this.setMailContext(mailContext);
    }

    public Component getSummary() {
        Party customer;
        Component result = null;
        CustomerOrderCRUDWindow window = (CustomerOrderCRUDWindow)this.getCRUDWindow();
        Party party = customer = window != null ? window.getCustomer() : null;
        if (customer != null) {
            CustomerPatientSummaryFactory factory = (CustomerPatientSummaryFactory)ServiceHelper.getBean(CustomerPatientSummaryFactory.class);
            CustomerSummary summary = factory.createCustomerSummary(this.getContext(), this.getHelpContext(), this.preferences);
            result = summary.getSummary(customer);
        }
        return result;
    }

    protected Browser<FinancialAct> createBrowser(Query<FinancialAct> query) {
        DefaultLayoutContext layoutContext = new DefaultLayoutContext(this.getContext(), this.getHelpContext());
        layoutContext.setContextSwitchListener((ContextSwitchListener)DefaultContextSwitchListener.INSTANCE);
        return BrowserFactory.create(query, (LayoutContext)layoutContext);
    }

    protected Query<FinancialAct> createQuery() {
        return new CustomerOrderQuery(SHORT_NAMES, (LayoutContext)new DefaultLayoutContext(this.getContext(), this.getHelpContext()));
    }

    protected CRUDWindow<FinancialAct> createCRUDWindow() {
        QueryBrowser browser = this.getBrowser();
        return new CustomerOrderCRUDWindow((Archetypes<FinancialAct>)this.getArchetypes(), (Query<FinancialAct>)browser.getQuery(), (ResultSet<FinancialAct>)browser.getResultSet(), this.getContext(), this.getHelpContext());
    }

    protected void onBrowserSelected(FinancialAct object) {
        super.onBrowserSelected((IMObject)object);
        if (this.updateSummaryOnChildUpdate()) {
            this.firePropertyChange("summary", null, null);
        }
    }
}

