/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.OrConstraint;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.ParticipantConstraint;

public class SMSResultSet
extends ActResultSet<Act> {
    private final Party location;
    private final List<Party> locations;

    public SMSResultSet(ShortNameConstraint archetypes, String value, Party location, List<Party> locations, Date from, Date to, String[] statuses, int pageSize, SortConstraint[] sort) {
        super(archetypes, value, (ParticipantConstraint[])null, from, to, statuses, false, null, pageSize, sort);
        this.location = location;
        this.locations = locations;
    }

    protected ArchetypeQuery createQuery() {
        ArchetypeQuery query = super.createQuery();
        query.getArchetypeConstraint().setAlias("act");
        String value = this.getValue();
        if (!StringUtils.isEmpty((CharSequence)value) && this.getId(value) == null) {
            query.add((IConstraint)Constraints.leftJoin((String)"contact").add((IConstraint)Constraints.leftJoin((String)"entity", (String)"contacte")));
            query.add((IConstraint)Constraints.leftJoin((String)"customer").add((IConstraint)Constraints.leftJoin((String)"entity", (String)"customere")));
            query.add((IConstraint)Constraints.leftJoin((String)"patient").add((IConstraint)Constraints.leftJoin((String)"entity", (String)"patiente")));
            query.add((IConstraint)Constraints.or((IConstraint[])new IConstraint[]{Constraints.eq((String)"contacte.name", (Object)value), Constraints.eq((String)"customere.name", (Object)value), Constraints.eq((String)"patiente.name", (Object)value)}));
        }
        if (this.location != null || !this.locations.isEmpty()) {
            query.add((IConstraint)Constraints.leftJoin((String)"location", (String)"location"));
            OrConstraint or = new OrConstraint();
            if (this.location != null) {
                or.add((IConstraint)Constraints.eq((String)"location.entity", (Object)this.location));
            } else {
                for (Party location : this.locations) {
                    or.add((IConstraint)Constraints.eq((String)"location.entity", (Object)location));
                }
            }
            or.add((IConstraint)Constraints.notExists((ArchetypeQuery)Constraints.subQuery((String[])this.getArchetypes().getShortNames(), (String)"i2").add((IConstraint)Constraints.join((String)"location").add((IConstraint)Constraints.join((String)"entity").add((IConstraint)Constraints.idEq((String)"act", (String)"i2"))))));
            query.add((IConstraint)or);
        }
        return query;
    }
}

