/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.sms;

import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.LayoutData;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.messaging.sms.AbstractSMSMessageLayoutStrategy;

public class SMSReplyLayoutStrategy
extends AbstractSMSMessageLayoutStrategy {
    private static final String SMS = "sms";

    public SMSReplyLayoutStrategy() {
        this(true);
    }

    public SMSReplyLayoutStrategy(boolean showPatient) {
        super(showPatient, "startTime");
        ArchetypeNodes nodes = ArchetypeNodes.all().exclude(new String[]{"contact"}).exclude(new String[]{"status"});
        this.setArchetypeNodes(nodes);
    }

    @Override
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        if (parent != null) {
            this.getArchetypeNodes().exclude(new String[]{"phone", "customer", "patient", "location"});
        } else {
            IMObject sms = this.getBean(object).getSource(SMS, IMObject.class);
            if (sms != null) {
                this.getArchetypeNodes().complex(new String[]{SMS});
                this.addComponent(new ComponentState(this.getSMS(sms, context), properties.get(SMS)));
            }
        }
        return super.apply(object, properties, parent, context);
    }

    private Component getSMS(IMObject sms, LayoutContext context) {
        Reference reference;
        IMObjectBean bean = this.getBean(sms);
        IMObjectProperty message = new IMObjectProperty(sms, bean.getNode("message"));
        IMObjectProperty createdTime = new IMObjectProperty(sms, bean.getNode("createdTime"));
        ComponentGrid componentGrid = new ComponentGrid();
        Component created = this.getCreated((Property)createdTime, sms, context);
        created.setLayoutData((LayoutData)ComponentGrid.layout((Alignment)Alignment.ALIGN_RIGHT));
        componentGrid.add(new Component[]{created});
        componentGrid.add(new Component[]{this.createMultiLineText((Property)message, 3, 10, Styles.FULL_WIDTH, context).getComponent()});
        if (!context.isEdit() && context.getContextSwitchListener() != null && (reference = bean.getSourceRef("source")) != null && reference.isA("act.customerAppointment")) {
            String name = Messages.format((String)"imobject.link", (Object[])new Object[]{this.getDisplayName(reference.getArchetype())});
            IMObjectReferenceViewer viewer = new IMObjectReferenceViewer(reference, name, context.getContextSwitchListener(), context.getContext());
            componentGrid.add(new Component[]{viewer.getComponent()});
        }
        Grid grid = componentGrid.createGrid();
        grid.setWidth(new Extent(99, 2));
        return ColumnFactory.create((String)"Inset", (Component[])new Component[]{grid});
    }
}

