/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.text.TextComponent;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.filter.NodeFilter;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.workspace.workflow.messaging.messages.AbstractMessageLayoutStrategy;

public class SystemMessageLayoutStrategy
extends AbstractMessageLayoutStrategy {
    public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
        ComponentState to = this.createComponent(properties.get("to"), object, context);
        ComponentState description = this.createComponent(properties.get("description"), object, context);
        ComponentState message = this.createMessage(properties, context, !this.showItem(context, object));
        if (description.getComponent() instanceof TextComponent) {
            ((TextComponent)description.getComponent()).setWidth(Styles.FULL_WIDTH);
        }
        this.addComponent(to);
        this.addComponent(description);
        this.addComponent(message);
        return super.apply(object, properties, parent, context);
    }

    protected void doLayout(IMObject object, PropertySet properties, IMObject parent, Component container, LayoutContext context) {
        ArchetypeDescriptor archetype = context.getArchetypeDescriptor(object);
        ArchetypeNodes nodes = this.getArchetypeNodes();
        NodeFilter filter = this.getNodeFilter(object, context);
        List simple = nodes.getSimpleNodes(properties, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, object, filter);
        List complex = nodes.getComplexNodes(properties, (org.openvpms.component.model.archetype.ArchetypeDescriptor)archetype, object, filter);
        List to = ArchetypeNodes.include((List)simple, (String[])new String[]{"to"});
        List header = ArchetypeNodes.include((List)simple, (String[])new String[]{"description", "reason"});
        List fields = ArchetypeNodes.exclude((List)simple, (String[])new String[]{"to", "description", "reason", "startTime", "message", "status"});
        List message = ArchetypeNodes.include((List)simple, (String[])new String[]{"message"});
        ComponentGrid componentGrid = new ComponentGrid();
        ComponentSet toSet = this.createComponentSet(object, to, context);
        ComponentSet headerSet = this.createComponentSet(object, header, context);
        ComponentSet fieldSet = this.createComponentSet(object, fields, context);
        ComponentSet messageSet = this.createComponentSet(object, message, context);
        componentGrid.add(toSet);
        if (!context.isEdit()) {
            componentGrid.set(componentGrid.getRows() - 1, 3, ComponentGrid.layout((Alignment)Alignment.ALIGN_RIGHT), (Component)this.createDate((Act)object));
        }
        componentGrid.add(headerSet, 1, 2);
        componentGrid.add(fieldSet, 2);
        componentGrid.add(messageSet, 1, 2);
        if (!this.showItem(context, object)) {
            complex = ArchetypeNodes.exclude((List)complex, (String[])new String[]{"item"});
        }
        Grid grid = this.createGrid(componentGrid);
        grid.setWidth(Styles.FULL_WIDTH);
        Column child = ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{grid});
        this.doComplexLayout(object, parent, complex, (Component)child, context);
        container.add((Component)child);
    }

    private ComponentState createMessage(PropertySet properties, LayoutContext context, boolean fullHeight) {
        String styleName = fullHeight ? "UserMessage.message" : "SystemMessage.message";
        return this.createMessage(properties, context, styleName);
    }

    private boolean showItem(LayoutContext context, IMObject object) {
        boolean result = context.isEdit();
        if (!result) {
            IMObjectBean bean = this.getBean(object);
            result = bean.hasNode("item") && !bean.getTargetRefs("item").isEmpty();
        }
        return result;
    }
}

