/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.messaging.messages;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import nextapp.echo2.app.ApplicationInstance;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openvpms.archetype.rules.message.MessageArchetypes;
import org.openvpms.archetype.rules.message.MessageRules;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.user.User;
import org.openvpms.web.echo.spring.SpringApplicationInstance;
import org.openvpms.web.echo.util.TaskQueue;
import org.openvpms.web.echo.util.TaskQueues;

public class MessageMonitor {
    private final IArchetypeService service;
    private final MessageRules rules;
    private final Map<Reference, List<Listener>> listeners = new HashMap<Reference, List<Listener>>();
    private int pollInterval = 30;
    private static final int DEFAULT_POLL_INTERVAL = 30;
    private static final Log log = LogFactory.getLog(MessageMonitor.class);

    public MessageMonitor(IArchetypeService service) {
        this.service = service;
        this.rules = new MessageRules(service);
        AbstractArchetypeServiceListener listener = new AbstractArchetypeServiceListener(){

            public void saved(IMObject object) {
                MessageMonitor.this.onMessage((Act)object);
            }
        };
        service.addListener("act.userMessage", (IArchetypeServiceListener)listener);
        service.addListener(MessageArchetypes.SYSTEM_MESSAGES, (IArchetypeServiceListener)listener);
        service.addListener("act.auditMessage", (IArchetypeServiceListener)listener);
    }

    public boolean hasNewMessages(User user, Date date) {
        return this.rules.hasNewMessages(user, date);
    }

    public synchronized void addListener(User user, MessageListener listener) {
        Reference userRef = user.getObjectReference();
        List<Listener> userListeners = this.listeners.get(userRef);
        if (userListeners == null) {
            userListeners = new ArrayList<Listener>();
            this.listeners.put(userRef, userListeners);
        } else {
            this.purge(userListeners);
        }
        userListeners.add(new Listener(listener, this.pollInterval));
    }

    public void setPollInterval(int interval) {
        if (interval > 0) {
            this.pollInterval = interval;
        }
    }

    public synchronized void removeListener(User user, MessageListener listener) {
        Reference userRef = user.getObjectReference();
        List<Listener> userListeners = this.listeners.get(userRef);
        if (userListeners != null) {
            this.purge(userListeners);
            ListIterator<Listener> iter = userListeners.listIterator();
            while (iter.hasNext()) {
                Listener state = iter.next();
                if (!Objects.equals(state.getMessageListener(), listener)) continue;
                iter.remove();
                break;
            }
        }
    }

    private void onMessage(Act message) {
        Listener[] array = this.getListeners(message);
        if (array != null) {
            for (Listener listener : array) {
                listener.queue(message);
            }
        }
    }

    private synchronized Listener[] getListeners(Act message) {
        List<Listener> list;
        Listener[] result = null;
        IMObjectBean bean = this.service.getBean((IMObject)message);
        Reference to = bean.getTargetRef("to");
        if (to != null && (list = this.listeners.get(to)) != null) {
            this.purge(list);
            result = list.toArray(new Listener[0]);
        }
        return result;
    }

    private void purge(List<Listener> listeners) {
        ListIterator<Listener> iter = listeners.listIterator();
        while (iter.hasNext()) {
            Listener listener = iter.next();
            if (listener.active()) continue;
            listener.destroy();
            iter.remove();
        }
    }

    private static class Listener {
        final WeakReference<MessageListener> listenerRef;
        final TaskQueue taskQueue;
        final int hashCode;

        public Listener(MessageListener listener, int pollInterval) {
            SpringApplicationInstance app = (SpringApplicationInstance)ApplicationInstance.getActive();
            if (app == null) {
                throw new IllegalStateException("No current ApplicationInstance");
            }
            this.taskQueue = app.getTaskQueues().newQueue(pollInterval, TaskQueues.QueueMode.QUEUE_LAST);
            this.listenerRef = new WeakReference<MessageListener>(listener);
            this.hashCode = listener.hashCode();
        }

        public MessageListener getMessageListener() {
            return (MessageListener)this.listenerRef.get();
        }

        public boolean active() {
            return this.getMessageListener() != null;
        }

        public void queue(Act message) {
            if (this.getMessageListener() != null) {
                this.taskQueue.queue(() -> {
                    MessageListener l = this.getMessageListener();
                    if (l != null) {
                        try {
                            l.onMessage(message);
                        }
                        catch (Exception exception) {
                            log.error((Object)"MessageListener threw exception, ignoring", (Throwable)exception);
                        }
                    }
                });
            } else {
                log.error((Object)"TaskQueue has been removed");
            }
        }

        public void destroy() {
            this.listenerRef.clear();
            this.taskQueue.dispose();
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Listener) {
                Listener other = (Listener)obj;
                return Objects.equals(this.listenerRef.get(), other.listenerRef.get());
            }
            return false;
        }
    }

    public static interface MessageListener {
        public void onMessage(Act var1);
    }
}

