/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.DocumentJobManager;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.im.report.Reporter;
import org.openvpms.web.component.im.report.ReporterFactory;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.mail.MailDialogFactory;
import org.openvpms.web.component.mail.MailEditor;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;

class PrintDocumentsMailer {
    private final TaskContext context;
    private final MailDialogFactory factory;
    private final ReporterFactory reporterFactory;
    private final DocumentJobManager jobManager;

    public PrintDocumentsMailer(TaskContext context) {
        this.context = context;
        this.factory = (MailDialogFactory)ServiceHelper.getBean(MailDialogFactory.class);
        this.reporterFactory = (ReporterFactory)ServiceHelper.getBean(ReporterFactory.class);
        this.jobManager = (DocumentJobManager)ServiceHelper.getBean(DocumentJobManager.class);
    }

    public <T extends IMObject> void mail(List<T> attachments, Runnable listener) {
        HelpContext email = this.context.getHelpContext().subtopic("email");
        CustomerMailContext mailContext = new CustomerMailContext((Context)this.context, true, email);
        MailDialog dialog = this.factory.create((MailContext)mailContext, (LayoutContext)new DefaultLayoutContext((Context)this.context, email));
        if (attachments.size() == 1) {
            this.mailSingleAttachment(dialog, (IMObject)attachments.get(0), listener);
        } else {
            this.mailMultipleAttachments(dialog, attachments, listener);
        }
    }

    private void mailSingleAttachment(MailDialog dialog, IMObject attachment, Runnable listener) {
        MailEditor editor = dialog.getMailEditor();
        this.addAttachment(editor, attachment, template -> {
            this.setContent(editor, attachment, (DocumentTemplate)template);
            PrintDocumentsMailer.show(dialog, listener);
        });
    }

    private <T extends IMObject> void mailMultipleAttachments(MailDialog dialog, List<T> attachments, Runnable listener) {
        MostRecentInvoice state = new MostRecentInvoice();
        MailEditor editor = dialog.getMailEditor();
        this.addAttachments(editor, attachments.iterator(), state, () -> {
            if (state.getInvoice() != null) {
                this.setContent(editor, (IMObject)state.getInvoice(), state.getTemplate());
            }
            PrintDocumentsMailer.show(dialog, listener);
        });
    }

    private static void show(final MailDialog dialog, final Runnable listener) {
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                if ("send".equals(dialog.getAction())) {
                    listener.run();
                }
            }
        });
        dialog.show();
    }

    private <T extends IMObject> void addAttachments(MailEditor editor, Iterator<T> attachments, MostRecentInvoice state, Runnable listener) {
        if (attachments.hasNext()) {
            IMObject attachment = (IMObject)attachments.next();
            this.addAttachment(editor, attachment, template -> {
                state.update(attachment, (DocumentTemplate)template);
                this.addAttachments(editor, attachments, state, listener);
            });
        } else {
            listener.run();
        }
    }

    private void addAttachment(MailEditor editor, IMObject object, Consumer<DocumentTemplate> listener) {
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator(object, (Context)this.context);
        Reporter reporter = this.reporterFactory.create(object, (DocumentTemplateLocator)locator, Reporter.class);
        reporter.setFields(ReportContextFactory.create((Context)this.context));
        Job job = JobBuilder.newJob((String)"Mail Attachment", (User)this.context.getUser()).get(() -> reporter.getDocument("application/pdf", true)).completed(document -> {
            editor.addAttachment(document);
            listener.accept(reporter.getTemplate());
        }).build();
        this.jobManager.runInteractive(job, Messages.get((String)"document.generateattachment.title"), Messages.get((String)"document.generateattachment.cancel"));
    }

    private void setContent(MailEditor editor, IMObject object, DocumentTemplate template) {
        EmailTemplate emailTemplate;
        if (template != null && (emailTemplate = template.getEmailTemplate()) != null) {
            editor.setObject((Object)object);
            editor.setContent(emailTemplate);
        }
    }

    private static class MostRecentInvoice {
        private Act invoice;
        private DocumentTemplate invoiceTemplate;

        private MostRecentInvoice() {
        }

        public void update(IMObject attachment, DocumentTemplate template) {
            if (attachment.isA("act.customerAccountChargesInvoice")) {
                Act act = (Act)attachment;
                if (this.invoice == null || DateRules.compareTo((Date)this.invoice.getActivityStartTime(), (Date)act.getActivityStartTime()) < 0) {
                    this.invoice = act;
                    this.invoiceTemplate = template;
                }
            }
        }

        public Act getInvoice() {
            return this.invoice;
        }

        public DocumentTemplate getTemplate() {
            return this.invoiceTemplate;
        }
    }
}

