/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.util.Date;
import org.openvpms.component.business.domain.im.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorSaver;
import org.openvpms.web.component.im.edit.act.ActEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.checkout.CheckoutEditInvoiceTask;

class PostInvoiceTask
extends EditIMObjectTask {
    private final ArchetypeService service;
    private boolean first = true;

    public PostInvoiceTask(ArchetypeService service) {
        super("act.customerAccountChargesInvoice", false, false);
        this.service = service;
    }

    protected void edit(IMObjectEditor editor, TaskContext context) {
        ActEditor actEditor = (ActEditor)editor;
        actEditor.setStatus("POSTED");
        actEditor.setStartTime(new Date());
    }

    protected void interactiveEdit(IMObjectEditor editor, TaskContext context) {
        super.interactiveEdit(editor, context);
    }

    protected void backgroundSave(IMObjectEditor editor, TaskContext context) {
        if (this.first) {
            IMObjectEditorSaver saver = new IMObjectEditorSaver();
            if (saver.save(editor, true)) {
                this.notifyCompleted();
            } else {
                this.backgroundEditFailed(editor, context);
            }
        } else {
            super.backgroundSave(editor, context);
        }
    }

    protected void backgroundEditFailed(IMObjectEditor editor, TaskContext context) {
        if (this.first) {
            this.first = false;
            FinancialAct invoice = (FinancialAct)context.getObject("act.customerAccountChargesInvoice");
            if (invoice != null) {
                invoice = (FinancialAct)this.service.get((Reference)invoice.getObjectReference(), FinancialAct.class);
            }
            if (invoice != null) {
                context.addObject((IMObject)invoice);
                this.edit(context);
            } else {
                this.invoiceDeleted();
            }
        } else {
            this.notifyCancelled();
        }
    }

    protected LayoutContext createLayoutContext(TaskContext context) {
        return CheckoutEditInvoiceTask.createProtectedLocationLayoutContext(context);
    }

    private void invoiceDeleted() {
        ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().title(Messages.get((String)"workflow.checkout.postinvoice.title"))).message(Messages.get((String)"workflow.checkout.postinvoice.deleted"))).listener(() -> ((PostInvoiceTask)this).notifyCancelled())).show();
    }
}

