/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.math.BigDecimal;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.workflow.EditIMObjectTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.workspace.customer.payment.CustomerPaymentEditor;

public class PaymentEditTask
extends EditIMObjectTask {
    private final BigDecimal chargeAmount;

    public PaymentEditTask(BigDecimal chargeAmount) {
        super("act.customerAccountPayment", true);
        this.chargeAmount = chargeAmount;
    }

    protected IMObjectEditor createEditor(IMObject object, TaskContext context) {
        FinancialAct invoice;
        DefaultLayoutContext layout = new DefaultLayoutContext(true, (Context)context, context.getHelpContext());
        BigDecimal amount = this.chargeAmount;
        if (amount.compareTo(BigDecimal.ZERO) == 0 && (invoice = (FinancialAct)context.getObject("act.customerAccountChargesInvoice")) != null) {
            amount = invoice.getTotal();
        }
        return new CustomerPaymentEditor((FinancialAct)object, null, (LayoutContext)layout, amount);
    }
}

