/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkout;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.insurance.InsuranceRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientContextFactory;
import org.openvpms.hl7.patient.PatientInformationService;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.HospitalizationService;
import org.openvpms.smartflow.model.Hospitalization;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.retry.AbstractRetryable;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.retry.Retryer;
import org.openvpms.web.component.workflow.AbstractConfirmationTask;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.ConditionalCreateTask;
import org.openvpms.web.component.workflow.ConditionalTask;
import org.openvpms.web.component.workflow.ConfirmationTask;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.EvalTask;
import org.openvpms.web.component.workflow.ReloadTask;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskFactory;
import org.openvpms.web.component.workflow.TaskProperties;
import org.openvpms.web.component.workflow.Tasks;
import org.openvpms.web.component.workflow.UpdateIMObjectTask;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.charge.UndispensedOrderChecker;
import org.openvpms.web.workspace.customer.charge.UndispensedOrderDialog;
import org.openvpms.web.workspace.workflow.GetClinicalEventTask;
import org.openvpms.web.workspace.workflow.MandatoryCustomerAlertTask;
import org.openvpms.web.workspace.workflow.MandatoryPatientAlertTask;
import org.openvpms.web.workspace.workflow.WorkflowException;
import org.openvpms.web.workspace.workflow.checkout.CheckoutEditInvoiceTask;
import org.openvpms.web.workspace.workflow.checkout.FollowUpTask;
import org.openvpms.web.workspace.workflow.checkout.GetBoardingAppointmentsTask;
import org.openvpms.web.workspace.workflow.checkout.GetCheckOutInvoiceTask;
import org.openvpms.web.workspace.workflow.checkout.InsuranceClaimTask;
import org.openvpms.web.workspace.workflow.checkout.InvoiceViewerDialog;
import org.openvpms.web.workspace.workflow.checkout.PostInvoiceTask;
import org.openvpms.web.workspace.workflow.checkout.PrintDocumentsTask;
import org.openvpms.web.workspace.workflow.checkout.Visit;
import org.openvpms.web.workspace.workflow.checkout.Visits;
import org.openvpms.web.workspace.workflow.i18n.WorkflowMessages;
import org.openvpms.web.workspace.workflow.payment.PaymentWorkflow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckOutWorkflow
extends WorkflowImpl {
    private final Context external;
    private final Visits visits;
    private final IArchetypeService service;
    private final AppointmentRules appointmentRules;
    private final InsuranceRules insuranceRules;
    private final FlowSheetServiceFactory flowSheetServiceFactory;
    private final ClaimAtCheckout claimAtCheckout;
    private TaskContext initial;
    private static final Logger log = LoggerFactory.getLogger(CheckOutWorkflow.class);

    public CheckOutWorkflow(Act act, Context context, HelpContext help) {
        super(help.topic("workflow/checkout"));
        Party practice = context.getPractice();
        if (practice == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoPractice());
        }
        this.external = context;
        this.service = ServiceHelper.getArchetypeService();
        this.appointmentRules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
        this.insuranceRules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
        this.visits = new Visits(context.getCustomer(), this.appointmentRules, (PatientRules)ServiceHelper.getBean(PatientRules.class), this.service);
        this.flowSheetServiceFactory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);
        this.claimAtCheckout = this.getClaimAtCheckout(practice);
        this.initialise(act, this.getHelpContext());
    }

    public void start() {
        super.start(this.initial);
    }

    public Visits getVisits() {
        return this.visits;
    }

    protected CheckoutEditInvoiceTask createChargeTask(Visits visits) {
        return new CheckoutEditInvoiceTask(visits);
    }

    protected PaymentWorkflow createPaymentWorkflow(TaskContext context) {
        return new PaymentWorkflow(context, this.external, context.getHelpContext().subtopic("pay"));
    }

    protected EvalTask<Boolean> getPostCondition() {
        String invoiceTitle = Messages.get((String)"workflow.checkout.postinvoice.title");
        String invoiceMsg = Messages.get((String)"workflow.checkout.postinvoice.message");
        return new ConfirmationTask(invoiceTitle, invoiceMsg, this.getHelpContext().subtopic("post"));
    }

    private void initialise(Act act, HelpContext help) {
        User clinician;
        IMObjectBean bean = this.service.getBean((IMObject)act);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        List policies = Collections.emptyList();
        if (customer == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoCustomer());
        }
        if (patient == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoPatient());
        }
        if (UserHelper.useLoggedInClinician((Context)this.external)) {
            clinician = this.external.getUser();
        } else {
            clinician = (User)bean.getTarget("clinician", User.class);
            if (clinician == null) {
                clinician = this.external.getClinician();
            }
        }
        this.initial = new DefaultTaskContext(help);
        this.initial.addObject((IMObject)act);
        this.initial.setCustomer(customer);
        this.initial.setPatient(patient);
        this.initial.setClinician(clinician);
        this.initial.setUser(this.external.getUser());
        this.initial.setPractice(this.external.getPractice());
        this.initial.setLocation(this.external.getLocation());
        this.initial.setDepartment(this.external.getDepartment());
        this.addTask((Task)new MandatoryCustomerAlertTask());
        this.addTask((Task)new MandatoryPatientAlertTask());
        final Act appointment = this.getAppointment(act, patient);
        if (appointment != null && this.appointmentRules.isBoardingAppointment(appointment)) {
            this.addTask((Task)new GetBoardingAppointmentsTask(appointment, this.visits));
        } else {
            this.addTask((Task)new GetClinicalEventTask(act.getActivityStartTime()));
            this.addTask((Task)new SynchronousTask(){

                public void execute(TaskContext context) {
                    Act event = (Act)context.getObject("act.patientClinicalEvent");
                    if (event == null) {
                        throw new WorkflowException(WorkflowMessages.contextHasNoVisit());
                    }
                    CheckOutWorkflow.this.visits.add(event, appointment);
                }
            });
            if (this.claimAtCheckout != ClaimAtCheckout.NONE) {
                policies = this.insuranceRules.getCurrentPolicies(customer, patient);
            }
        }
        if (this.flowSheetServiceFactory.isSmartFlowSheetEnabled(this.initial.getLocation())) {
            this.addTask((Task)new BatchDischargeFromSmartFlowSheetTask(this.visits, help));
        }
        this.addTask((Task)new GetCheckOutInvoiceTask(this.visits));
        this.addTask((Task)new ConditionalCreateTask("act.customerAccountChargesInvoice"));
        this.addTask((Task)new InvoiceTask(this.getHelpContext()));
        this.addTask(TaskFactory.when((EvalTask)TaskFactory.ne((String)"act.customerAccountChargesInvoice", (String)"status", (Object)"POSTED"), (Task)this.getPostTask()));
        Tasks tasks = new Tasks(help);
        if (!(policies.isEmpty() || this.claimAtCheckout != ClaimAtCheckout.ALL && this.claimAtCheckout != ClaimAtCheckout.GAP_CLAIM)) {
            tasks.addTask(TaskFactory.when((EvalTask)new UnclaimedUnpaidInvoice(), (Task)new InsuranceClaimTask(policies, true, help)));
        }
        PaymentWorkflow payWorkflow = this.createPaymentWorkflow(this.initial);
        payWorkflow.addTask((Task)new ReloadTask("act.customerAccountChargesInvoice"));
        payWorkflow.setRequired(false);
        tasks.addTask(TaskFactory.when((EvalTask)new PositiveBalance(), (Task)payWorkflow));
        if (!(policies.isEmpty() || this.claimAtCheckout != ClaimAtCheckout.ALL && this.claimAtCheckout != ClaimAtCheckout.STANDARD_CLAIM)) {
            tasks.addTask(TaskFactory.when((EvalTask)new UnclaimedPaidInvoice(), (Task)new InsuranceClaimTask(policies, false, help)));
        }
        this.addTask(TaskFactory.when((EvalTask)TaskFactory.eq((String)"act.customerAccountChargesInvoice", (String)"status", (Object)"POSTED"), (Task)tasks));
        this.addTask((Task)new PrintTask(this.visits, help.subtopic("print")));
        if (this.followUp()) {
            this.addTask((Task)new FollowUpTask(help));
        }
        this.addTask((Task)new UpdateEventTask(this.visits));
        this.addTask((Task)new DischargeTask(this.visits));
        if (act.isA("act.customerTask")) {
            TaskProperties appProps = new TaskProperties();
            appProps.add("status", (Object)"COMPLETED");
            appProps.add("endTime", Date::new);
            UpdateIMObjectTask task = new UpdateIMObjectTask(act.getArchetype(), appProps);
            task.skipIfMissing();
            this.addTask((Task)task);
        }
        this.addTask((Task)new SynchronousTask(){

            public void execute(TaskContext context) {
                CheckOutWorkflow.this.external.setCustomer(context.getCustomer());
                CheckOutWorkflow.this.external.setPatient(context.getPatient());
                CheckOutWorkflow.this.external.setTill(context.getTill());
                CheckOutWorkflow.this.external.setTerminal(context.getTerminal());
                CheckOutWorkflow.this.external.setClinician(context.getClinician());
                CheckOutWorkflow.this.external.setDepartment(context.getDepartment());
            }
        });
    }

    private Act getAppointment(Act act, Party patient) {
        Act result;
        if (act.isA("act.customerAppointment")) {
            result = act;
        } else {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            result = (Act)bean.getSource("appointments", Act.class);
            if (result == null) {
                result = this.appointmentRules.getActivePatientAppointment(patient);
            }
        }
        return result;
    }

    private Task getPostTask() {
        HelpContext help = this.getHelpContext().subtopic("post");
        Tasks postTasks = new Tasks(help);
        postTasks.addTask((Task)new PostInvoiceTask((ArchetypeService)this.service));
        postTasks.setRequired(false);
        EvalTask<Boolean> confirmPost = this.getPostCondition();
        UndispensedOrderTask checkUndispensed = new UndispensedOrderTask(help);
        ConditionalTask post = new ConditionalTask(confirmPost, TaskFactory.when((EvalTask)checkUndispensed, (Task)postTasks));
        post.setRequired(false);
        return post;
    }

    private boolean followUp() {
        boolean result = false;
        Party practice = this.external.getPractice();
        if (practice != null) {
            IMObjectBean bean = this.service.getBean((IMObject)practice);
            result = bean.getBoolean("followUpAtCheckOut");
        }
        return result;
    }

    private ClaimAtCheckout getClaimAtCheckout(Party practice) {
        String result = this.service.getBean((IMObject)practice).getString("claimAtCheckout", "ALL");
        return ClaimAtCheckout.valueOf(result);
    }

    private static class DischargeFromSmartFlowSheetTask
    extends AbstractTask {
        private final PatientContext patientContext;
        private final HospitalizationService service;

        public DischargeFromSmartFlowSheetTask(PatientContext context, HospitalizationService service) {
            this.patientContext = context;
            this.service = service;
        }

        public void start(TaskContext context) {
            try {
                this.service.discharge(this.patientContext.getPatient(), this.patientContext.getVisit());
                this.notifyCompleted();
            }
            catch (Exception exception) {
                log.error(exception.getMessage(), (Throwable)exception);
                ((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)((ErrorDialogBuilder)ErrorDialog.newDialog().title(Messages.get((String)"workflow.checkout.flowsheet.discharge.title"))).message(Messages.format((String)"workflow.checkout.flowsheet.discharge.error", (Object[])new Object[]{exception.getMessage()}))).yesNoCancel()).yes(() -> this.start(context))).no(() -> ((DischargeFromSmartFlowSheetTask)this).notifyCompleted())).cancel(() -> ((DischargeFromSmartFlowSheetTask)this).notifyCancelled())).show();
            }
        }
    }

    private static class DischargeTask
    extends SynchronousTask {
        private final Visits visits;

        DischargeTask(Visits visits) {
            this.visits = visits;
        }

        public void execute(TaskContext context) {
            PatientContextFactory factory = (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class);
            PatientInformationService service = (PatientInformationService)ServiceHelper.getBean(PatientInformationService.class);
            for (Visit event : this.visits) {
                Act act = event.getEvent();
                PatientContext pc = factory.createContext(event.getPatient(), context.getCustomer(), act, context.getLocation(), context.getClinician());
                service.discharged(pc);
            }
        }
    }

    private static class PrintTask
    extends Tasks {
        private final Visits visits;

        PrintTask(Visits visits, HelpContext help) {
            super(help);
            this.visits = visits;
        }

        protected void initialise(TaskContext context) {
            Date min = new Date();
            for (Visit event : this.visits) {
                min = this.getMin(min, event.getEvent().getActivityStartTime());
            }
            Act invoice = (Act)context.getObject("act.customerAccountChargesInvoice");
            if (invoice != null) {
                min = this.getMin(min, invoice.getActivityStartTime());
            }
            min = DateRules.getDate((Date)min);
            PrintDocumentsTask printDocs = new PrintDocumentsTask(this.visits.getPatients(), min, context.getHelpContext());
            printDocs.setRequired(false);
            this.addTask((Task)printDocs);
        }

        private Date getMin(Date date1, Date date2) {
            Date min = date1;
            if (date1.getTime() > date2.getTime()) {
                min = date2;
            }
            return min;
        }
    }

    private static class PositiveBalance
    extends EvalTask<Boolean> {
        private PositiveBalance() {
        }

        public void start(TaskContext context) {
            Party customer = context.getCustomer();
            CustomerAccountRules rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);
            BigDecimal balance = rules.getBalance(customer);
            if (balance.compareTo(BigDecimal.ZERO) > 0) {
                this.setValue(true);
            } else {
                this.setValue(false);
            }
        }
    }

    private static class UnclaimedPaidInvoice
    extends EvalTask<Boolean> {
        private UnclaimedPaidInvoice() {
        }

        public void start(TaskContext context) {
            FinancialAct invoice = (FinancialAct)IMObjectHelper.reload((IMObject)context.getObject("act.customerAccountChargesInvoice"));
            boolean value = false;
            if (invoice != null && "POSTED".equals(invoice.getStatus()) && !MathRules.isZero((BigDecimal)invoice.getTotal()) && MathRules.equals((BigDecimal)invoice.getTotal(), (BigDecimal)invoice.getAllocatedAmount())) {
                InsuranceRules rules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
                value = !rules.isClaimed(invoice);
            }
            this.setValue(value);
        }
    }

    private static class UnclaimedUnpaidInvoice
    extends EvalTask<Boolean> {
        private UnclaimedUnpaidInvoice() {
        }

        public void start(TaskContext context) {
            FinancialAct invoice = (FinancialAct)IMObjectHelper.reload((IMObject)context.getObject("act.customerAccountChargesInvoice"));
            boolean value = false;
            if (invoice != null && "POSTED".equals(invoice.getStatus()) && !MathRules.isZero((BigDecimal)invoice.getTotal()) && invoice.getAllocatedAmount().compareTo(invoice.getTotal()) < 0) {
                InsuranceRules rules = (InsuranceRules)ServiceHelper.getBean(InsuranceRules.class);
                value = !rules.isClaimed(invoice);
            }
            this.setValue(value);
        }
    }

    private static class UndispensedOrderTask
    extends AbstractConfirmationTask {
        private UndispensedOrderChecker checker;

        UndispensedOrderTask(HelpContext help) {
            super(help);
        }

        public void start(TaskContext context) {
            Act invoice = (Act)context.getObject("act.customerAccountChargesInvoice");
            if (invoice != null) {
                this.checker = new UndispensedOrderChecker(invoice);
                if (this.checker.hasUndispensedItems()) {
                    super.start(context);
                } else {
                    this.setValue(true);
                }
            } else {
                this.setValue(false);
            }
        }

        protected ConfirmationDialog createConfirmationDialog(TaskContext context, HelpContext help) {
            return new UndispensedOrderDialog(this.checker.getUndispensedItems(), help);
        }
    }

    private class UpdateEventTask
    extends SynchronousTask {
        private final Visits visits;

        UpdateEventTask(Visits visits) {
            this.visits = visits;
        }

        public void execute(TaskContext context) {
            for (final Visit event : this.visits) {
                AbstractRetryable action = new AbstractRetryable(){

                    protected boolean runFirst() {
                        return UpdateEventTask.this.update(true, event);
                    }

                    protected boolean runAction() {
                        return UpdateEventTask.this.update(false, event);
                    }
                };
                if (Retryer.run((Retryable)action)) continue;
                this.notifyCancelled();
            }
        }

        private boolean updateEvent(Visit visit, List<Act> toSave) {
            Act event = visit.reloadEvent();
            if (event != null && "IN_PROGRESS".equals(event.getStatus())) {
                event.setStatus("COMPLETED");
                event.setActivityEndTime(new Date());
                toSave.add(event);
            }
            return event != null;
        }

        private boolean update(boolean first, Visit event) {
            ArrayList<Act> toSave = new ArrayList<Act>();
            boolean result = this.updateAppointment(first, event.getAppointment(), toSave);
            result |= this.updateEvent(event, toSave);
            if (!toSave.isEmpty()) {
                CheckOutWorkflow.this.service.save(toSave);
            }
            return result;
        }

        private boolean updateAppointment(boolean first, Act appointment, List<Act> toSave) {
            if (!first) {
                appointment = (Act)IMObjectHelper.reload((IMObject)appointment);
            }
            if (appointment != null && !"COMPLETED".equals(appointment.getStatus())) {
                appointment.setStatus("COMPLETED");
                toSave.add(appointment);
            }
            return appointment != null;
        }
    }

    private class BatchDischargeFromSmartFlowSheetTask
    extends Tasks {
        private final Visits visits;

        public BatchDischargeFromSmartFlowSheetTask(Visits visits, HelpContext help) {
            super(help);
            this.setRequired(false);
            this.visits = visits;
        }

        protected void initialise(TaskContext context) {
            Party location = context.getLocation();
            boolean completed = true;
            if (location != null && !this.visits.isEmpty()) {
                PatientContextFactory factory = (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class);
                HospitalizationService service = CheckOutWorkflow.this.flowSheetServiceFactory.getHospitalizationService(location);
                for (Visit event : this.visits) {
                    Act act = event.getEvent();
                    PatientContext patientContext = factory.createContext(act, location);
                    Hospitalization hospitalization = service.getHospitalization(patientContext);
                    if (hospitalization == null || !"active".equals(hospitalization.getStatus())) continue;
                    completed = false;
                    String title = Messages.get((String)"workflow.checkout.flowsheet.discharge.title");
                    String message = Messages.format((String)"workflow.checkout.flowsheet.discharge.message", (Object[])new Object[]{patientContext.getPatientFirstName()});
                    ConfirmationTask confirm = new ConfirmationTask(title, message, true, CheckOutWorkflow.this.getHelpContext());
                    DischargeFromSmartFlowSheetTask discharge = new DischargeFromSmartFlowSheetTask(patientContext, service);
                    this.addTask((Task)new ConditionalTask((EvalTask)confirm, (Task)discharge));
                }
            }
            if (completed) {
                this.notifyCompleted();
            }
        }
    }

    private class InvoiceTask
    extends Tasks {
        InvoiceTask(HelpContext help) {
            super(help);
        }

        public void start(final TaskContext context) {
            FinancialAct invoice = (FinancialAct)context.getObject("act.customerAccountChargesInvoice");
            if (invoice == null) {
                this.notifyCancelled();
            } else if ("POSTED".equals(invoice.getStatus())) {
                InvoiceViewerDialog dialog = new InvoiceViewerDialog(invoice, CheckOutWorkflow.this.visits, (Context)context, context.getHelpContext());
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onAction(String action) {
                        if ("button.new".equals(action)) {
                            InvoiceTask.this.onNew(context);
                        }
                    }

                    public void onOK() {
                        InvoiceTask.this.notifyCompleted();
                    }

                    public void onCancel() {
                        InvoiceTask.this.notifyCancelled();
                    }
                });
                dialog.show();
            } else {
                this.addTask((Task)CheckOutWorkflow.this.createChargeTask(CheckOutWorkflow.this.visits));
                super.start(context);
            }
        }

        private void onNew(TaskContext context) {
            FinancialAct invoice = (FinancialAct)CheckOutWorkflow.this.service.create("act.customerAccountChargesInvoice", FinancialAct.class);
            context.addObject((IMObject)invoice);
            this.addTask((Task)CheckOutWorkflow.this.createChargeTask(CheckOutWorkflow.this.visits));
            InvoiceTask.super.start(context);
        }
    }

    public static enum ClaimAtCheckout {
        ALL,
        NONE,
        STANDARD_CLAIM,
        GAP_CLAIM;

    }
}

