/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.util.Date;
import nextapp.echo2.app.Component;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.util.EntityRelationshipHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.edit.Editor;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.edit.act.SingleParticipationCollectionEditor;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.EntityObjectSetQuery;
import org.openvpms.web.component.im.query.EntityQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.worklist.RestrictedWorkListParticipationEditor;
import org.openvpms.web.workspace.workflow.worklist.RestrictedWorkListTaskEditor;
import org.openvpms.web.workspace.workflow.worklist.ScheduleWorkListQuery;

class TaskPanel {
    private final TaskEditor editor;
    private Runnable listener;

    TaskPanel(Date arrivalTime, Act appointment, LayoutContext layoutContext, IArchetypeService service) {
        Act task = (Act)service.create("act.customerTask", Act.class);
        task.setActivityStartTime(arrivalTime);
        this.editor = new TaskEditor(task, appointment, layoutContext);
    }

    public void setPatient(Party patient) {
        this.editor.setPatient(patient);
    }

    public void setClinician(User clinician) {
        this.editor.setClinician(clinician);
    }

    public Act getTask() {
        Act act = this.editor.getObject();
        return act != null && !act.isNew() ? act : null;
    }

    public boolean validate(Validator validator) {
        return this.editor.isEmpty() || this.editor.validate(validator);
    }

    public void save() {
        if (!this.editor.isEmpty() && this.editor.isModified()) {
            this.editor.save();
        }
    }

    public FocusGroup layout(ComponentGrid grid) {
        this.editor.getComponent();
        SingleParticipationCollectionEditor workListEditor = this.editor.getWorkListCollectionEditor();
        workListEditor.addModifiableListener(modifiable -> this.onWorkListChanged());
        IMObjectCollectionEditor taskTypeEditor = this.editor.getTypeEditor();
        String taskTypeDisplayName = taskTypeEditor.getProperty().getDisplayName();
        grid.add(new Component[]{TableHelper.createSpacer()});
        grid.add(new Component[]{LabelFactory.text((String)this.editor.getDisplayName(), (String)"bold")});
        grid.add(new Component[]{LabelFactory.text((String)workListEditor.getProperty().getDisplayName()), workListEditor.getComponent(), LabelFactory.text((String)taskTypeDisplayName), taskTypeEditor.getComponent()});
        FocusGroup result = new FocusGroup("TaskPanel");
        result.add(workListEditor.getFocusGroup());
        result.add(taskTypeEditor.getFocusGroup());
        return result;
    }

    public void setWorkListListener(Runnable listener) {
        this.listener = listener;
    }

    public Entity getWorkList() {
        return this.editor.getWorkList();
    }

    public void setWorkList(Entity worklist) {
        this.editor.setWorkList(worklist);
    }

    public Entity getTaskType() {
        return this.editor.getTaskType();
    }

    public void setTaskType(Entity taskType) {
        this.editor.setTaskType(taskType);
    }

    Editor getWorkListEditor() {
        return this.editor.getWorkListCollectionEditor();
    }

    private void onWorkListChanged() {
        if (this.listener != null) {
            try {
                this.listener.run();
            }
            catch (Throwable exception) {
                ErrorHelper.show((Throwable)exception);
            }
        }
    }

    private static class TaskEditor
    extends RestrictedWorkListTaskEditor {
        private final Entity schedule;

        TaskEditor(Act task, Act appointment, LayoutContext context) {
            super(task, null, context);
            if (appointment != null) {
                IMObjectBean bean = this.getBean((IMObject)appointment);
                this.schedule = (Entity)bean.getTarget("schedule", Entity.class);
                String notes = this.getNotes(bean);
                Property property = this.getProperty("notes");
                int maxLength = property.getMaxLength();
                property.setValue((Object)StringUtils.abbreviate((String)notes, (int)maxLength));
            } else {
                this.schedule = null;
            }
            this.initWorkListEditor();
        }

        public IMObjectEditor newInstance() {
            return null;
        }

        @Override
        public SingleParticipationCollectionEditor getWorkListCollectionEditor() {
            return super.getWorkListCollectionEditor();
        }

        public boolean isEmpty() {
            return this.isNull("worklist") && this.isNull("taskType");
        }

        @Override
        protected Entity getDefaultWorkList() {
            IMObjectBean bean;
            boolean useAllWorkLists;
            Entity result = null;
            if (this.schedule != null && !(useAllWorkLists = (bean = this.getBean((IMObject)this.schedule)).getBoolean("useAllWorkLists", true))) {
                IArchetypeService service = this.getService();
                result = EntityRelationshipHelper.getDefaultTarget((Entity)this.schedule, (String)"workLists", (boolean)false, (ArchetypeService)service);
            }
            return result;
        }

        @Override
        protected ParticipationEditor<Entity> createWorkListEditor(Participation participation) {
            final LayoutContext layoutContext = this.getLayoutContext();
            return new RestrictedWorkListParticipationEditor(participation, this.getObject(), layoutContext){

                @Override
                protected Query<Entity> createWorkListQuery(String name) {
                    Party location = layoutContext.getContext().getLocation();
                    ScheduleWorkListQuery query = new ScheduleWorkListQuery(schedule, (Entity)location);
                    query.setValue(name);
                    return new EntityQuery((EntityObjectSetQuery)query, layoutContext.getContext());
                }
            };
        }

        @Override
        protected void onLayoutCompleted() {
            super.onLayoutCompleted();
            this.getWorkListCollectionEditor().getComponent().setLayoutData(null);
            this.getTaskTypeEditor().getComponent().setLayoutData(null);
        }

        IMObjectCollectionEditor getTypeEditor() {
            return (IMObjectCollectionEditor)this.getEditor("taskType");
        }

        private String getNotes(IMObjectBean bean) {
            Lookup lookup = bean.getLookup("reason");
            String reason = lookup != null ? lookup.getName() : Messages.get((String)"workflow.checkin.task.appointment");
            String appointmentNotes = bean.getString("notes");
            String notes = appointmentNotes != null ? Messages.format((String)"workflow.checkin.task.description", (Object[])new Object[]{reason, appointmentNotes}) : reason;
            return notes;
        }

        private boolean isNull(String name) {
            ParticipationEditor editor = this.getParticipationEditor(name, true);
            return editor == null || editor.isNull();
        }
    }
}

