/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientContextFactory;
import org.openvpms.hl7.patient.PatientInformationService;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.smartflow.client.HospitalizationService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.util.UserHelper;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.ConditionalCreateTask;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.LocalTask;
import org.openvpms.web.component.workflow.PrintIMObjectTask;
import org.openvpms.web.component.workflow.ReloadTask;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.component.workflow.Tasks;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.customer.CustomerMailContext;
import org.openvpms.web.workspace.workflow.EditVisitTask;
import org.openvpms.web.workspace.workflow.GetInvoiceTask;
import org.openvpms.web.workspace.workflow.WorkflowException;
import org.openvpms.web.workspace.workflow.checkin.CheckInDialog;
import org.openvpms.web.workspace.workflow.checkin.FlowSheetInfo;
import org.openvpms.web.workspace.workflow.checkin.PrintPatientActTask;
import org.openvpms.web.workspace.workflow.i18n.WorkflowMessages;

public class CheckInWorkflow
extends WorkflowImpl {
    private final ArchetypeService service = ServiceHelper.getArchetypeService();
    private TaskContext initial;
    private Context external;
    private FlowSheetServiceFactory flowSheetServiceFactory;
    private static final String HELP_TOPIC = "workflow/checkin";

    public CheckInWorkflow(Party customer, Party patient, Context context, HelpContext help) {
        super(help.topic(HELP_TOPIC));
        User clinician = UserHelper.useLoggedInClinician((Context)context) ? context.getUser() : null;
        this.initialise(null, customer, patient, clinician, context);
    }

    public CheckInWorkflow(Act appointment, Context context, HelpContext help) {
        super(help.topic(HELP_TOPIC));
        this.initialise(appointment, context);
    }

    protected CheckInWorkflow(HelpContext help) {
        super(help);
    }

    public void start() {
        super.start(this.initial);
    }

    protected void initialise(Act appointment, Context context) {
        IMObjectBean bean = this.service.getBean((IMObject)appointment);
        Party customer = (Party)bean.getTarget("customer", Party.class);
        Party patient = (Party)bean.getTarget("patient", Party.class);
        User clinician = UserHelper.useLoggedInClinician((Context)context) ? context.getUser() : (User)bean.getTarget("clinician", User.class);
        this.initialise(appointment, customer, patient, clinician, context);
    }

    protected Date getArrivalTime() {
        return new Date();
    }

    protected Context getInitialContext() {
        return this.initial;
    }

    protected EditVisitTask createEditVisitTask() {
        return new EditVisitTask();
    }

    private void initialise(Act appointment, Party customer, Party patient, User clinician, Context context) {
        this.flowSheetServiceFactory = (FlowSheetServiceFactory)ServiceHelper.getBean(FlowSheetServiceFactory.class);
        if (context.getPractice() == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoPractice());
        }
        this.external = context;
        HelpContext help = this.getHelpContext();
        this.initial = new DefaultTaskContext(help);
        if (appointment != null) {
            this.initial.addObject((IMObject)appointment);
            IMObjectBean bean = this.service.getBean((IMObject)appointment);
            Entity schedule = (Entity)bean.getTarget("schedule", Entity.class);
            if (schedule != null) {
                this.initial.addObject((IMObject)schedule);
            }
        }
        this.initial.setCustomer(customer);
        this.initial.setPatient(patient);
        this.initial.setClinician(clinician);
        this.initial.setUser(this.external.getUser());
        this.initial.setWorkListDate(new Date());
        this.initial.setScheduleDate(this.external.getScheduleDate());
        this.initial.setPractice(this.external.getPractice());
        this.initial.setLocation(this.external.getLocation());
        this.initial.setDepartment(this.external.getDepartment());
        Date arrivalTime = this.getArrivalTime();
        this.addTask((Task)new CheckInDialogTask(this.getHelpContext()));
        this.addTask((Task)new GetInvoiceTask());
        this.addTask((Task)new ConditionalCreateTask("act.customerAccountChargesInvoice"));
        this.addTask((Task)new AdmissionTask());
        EditVisitTask editVisitTask = this.createEditVisitTask();
        editVisitTask.addTaskListener((TaskListener)new DefaultTaskListener(){

            public void taskEvent(TaskEvent event) {
                if (event.getType() == TaskEvent.Type.CANCELLED) {
                    CancelAdmissionTask task = new CancelAdmissionTask();
                    task.execute(CheckInWorkflow.this.getContext());
                }
            }
        });
        this.addTask((Task)new LocalTask((Task)editVisitTask, new String[]{"party.patient*", "party.customer*", "entity.department"}));
        this.addTask((Task)new ReloadTask("act.patientClinicalEvent"));
        if (appointment != null) {
            this.addTask((Task)new UpdateAppointmentTask(appointment, arrivalTime));
        }
        this.addTask((Task)new SynchronousTask(){

            public void execute(TaskContext context) {
                CheckInWorkflow.this.external.setPatient(context.getPatient());
                CheckInWorkflow.this.external.setCustomer(context.getCustomer());
                CheckInWorkflow.this.external.setDepartment(context.getDepartment());
            }
        });
    }

    private static class CancelAdmissionTask
    extends SynchronousTask {
        private CancelAdmissionTask() {
        }

        public void execute(TaskContext context) {
            PatientContextFactory factory = (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class);
            Act visit = (Act)context.getObject("act.patientClinicalEvent");
            PatientContext pc = factory.createContext(context.getPatient(), context.getCustomer(), visit, context.getLocation(), context.getClinician());
            PatientInformationService service = (PatientInformationService)ServiceHelper.getBean(PatientInformationService.class);
            service.admissionCancelled(pc);
        }
    }

    private static class AdmissionTask
    extends SynchronousTask {
        private AdmissionTask() {
        }

        public void execute(TaskContext context) {
            PatientContextFactory factory = (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class);
            Act visit = (Act)context.getObject("act.patientClinicalEvent");
            PatientContext pc = factory.createContext(context.getPatient(), context.getCustomer(), visit, context.getLocation(), context.getClinician());
            PatientInformationService service = (PatientInformationService)ServiceHelper.getBean(PatientInformationService.class);
            service.admitted(pc);
        }
    }

    private class UpdateAppointmentTask
    extends SynchronousTask {
        private final Act appointment;
        private final Date arrivalTime;

        UpdateAppointmentTask(Act appointment, Date arrivalTime) {
            this.appointment = appointment;
            this.arrivalTime = arrivalTime;
        }

        public void execute(TaskContext context) {
            IMObjectBean currentBean;
            IMObjectBean existingBean;
            Act current = (Act)CheckInWorkflow.this.service.get(this.appointment.getObjectReference(), Act.class);
            if (current != null && current.getStatus().equals(this.appointment.getStatus()) && this.sameRef(existingBean = CheckInWorkflow.this.service.getBean((IMObject)this.appointment), currentBean = CheckInWorkflow.this.service.getBean((IMObject)current), "customer") && this.sameRef(existingBean, currentBean, "patient")) {
                current.setStatus("CHECKED_IN");
                currentBean.setValue("arrivalTime", (Object)this.arrivalTime);
                Act task = context.getTask();
                if (task != null) {
                    currentBean.setTarget("tasks", (IMObject)task);
                }
                if (!SaveHelper.save((IMObject)current)) {
                    this.notifyCancelled();
                }
                context.setAppointment(current);
            }
        }

        private boolean sameRef(IMObjectBean bean1, IMObjectBean bean2, String node) {
            return Objects.equals(bean1.getTargetRef(node), bean2.getTargetRef(node));
        }
    }

    private class CreateFlowSheetTask
    extends AbstractTask {
        private final FlowSheetInfo info;

        CreateFlowSheetTask(FlowSheetInfo info) {
            this.info = info;
            this.setRequired(false);
        }

        public void start(TaskContext context) {
            boolean popup = false;
            Act visit = (Act)context.getObject("act.patientClinicalEvent");
            Party patient = context.getPatient();
            Party location = context.getLocation();
            if (visit != null && location != null) {
                PatientContextFactory factory = (PatientContextFactory)ServiceHelper.getBean(PatientContextFactory.class);
                PatientContext patientContext = factory.createContext(patient, visit, location);
                try {
                    HospitalizationService service = CheckInWorkflow.this.flowSheetServiceFactory.getHospitalizationService(location);
                    service.add(patientContext, this.info.getExpectedStay(), this.info.getDepartmentId(), this.info.getTemplate());
                }
                catch (Throwable exception) {
                    popup = true;
                    ErrorHelper.show((Throwable)exception, () -> ((CreateFlowSheetTask)this).notifyCompleted());
                }
            }
            if (!popup) {
                this.notifyCompleted();
            }
        }
    }

    class CheckInDialogTask
    extends Tasks {
        private CheckInDialog dialog;

        CheckInDialogTask(HelpContext help) {
            super(help);
        }

        public void start(final TaskContext context) {
            this.dialog = new CheckInDialog(context.getCustomer(), context.getPatient(), (Entity)context.getSchedule(), context.getClinician(), context.getPractice(), context.getLocation(), CheckInWorkflow.this.getArrivalTime(), context.getAppointment(), context.getUser(), context.getHelpContext());
            this.dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    Collection<Entity> templates;
                    context.setPatient(CheckInDialogTask.this.dialog.getPatient());
                    context.setClinician(CheckInDialogTask.this.dialog.getClinician());
                    context.addObject((IMObject)CheckInDialogTask.this.dialog.getEvent());
                    context.setAppointment(CheckInDialogTask.this.dialog.getAppointment());
                    context.setTask(CheckInDialogTask.this.dialog.getTask());
                    FlowSheetInfo flowsheet = CheckInDialogTask.this.dialog.getFlowSheetInfo();
                    boolean completed = true;
                    if (flowsheet != null) {
                        CheckInDialogTask.this.addTask((Task)new CreateFlowSheetTask(flowsheet));
                        completed = false;
                    }
                    if (!(templates = CheckInDialogTask.this.dialog.getTemplates()).isEmpty()) {
                        CheckInDialogTask.this.addPrintTasks(templates, context);
                        completed = false;
                    }
                    if (completed) {
                        CheckInDialogTask.this.notifyCompleted();
                    } else {
                        CheckInDialogTask.super.start(context);
                    }
                }

                public void onAction(String action) {
                    CheckInDialogTask.this.notifyCancelled();
                }
            });
            this.dialog.show();
        }

        public CheckInDialog getCheckInDialog() {
            return this.dialog;
        }

        private void addPrintTasks(Collection<Entity> templates, TaskContext context) {
            CustomerMailContext mailContext = new CustomerMailContext((Context)context, context.getHelpContext());
            for (Entity entity : templates) {
                DocumentTemplate template = new DocumentTemplate(entity, CheckInWorkflow.this.service);
                String type = template.getType();
                if (type == null) continue;
                Act document = (Act)CheckInWorkflow.this.service.create(type, Act.class);
                IMObjectBean bean = CheckInWorkflow.this.service.getBean((IMObject)document);
                bean.setTarget("patient", (IMObject)context.getPatient());
                bean.setTarget("documentTemplate", (IMObject)entity);
                bean.setTarget("clinician", (IMObject)context.getClinician());
                this.addTask((Task)new PrintPatientActTask(document, (MailContext)mailContext, PrintIMObjectTask.PrintMode.BACKGROUND));
            }
        }
    }
}

