/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import java.util.Collection;
import java.util.Date;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.checkin.CheckInEditor;
import org.openvpms.web.workspace.workflow.checkin.FlowSheetInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class CheckInDialog
extends ModalDialog {
    private final PlatformTransactionManager transactionManager;
    private CheckInEditor editor;
    private Column container;
    private static final Logger log = LoggerFactory.getLogger(CheckInDialog.class);

    public CheckInDialog(Party customer, Party patient, Entity schedule, User clinician, Party practice, Party location, Date arrivalTime, Act appointment, User user, HelpContext help) {
        super(Messages.get((String)"patient.checkin.title"), "CheckInDialog", OK_CANCEL, help);
        this.resize();
        this.transactionManager = (PlatformTransactionManager)ServiceHelper.getBean(PlatformTransactionManager.class);
        this.editor = new CheckInEditor(customer, patient, schedule, clinician, location, arrivalTime, appointment, user, help);
    }

    public void show() {
        super.show();
        this.editor.showAlerts();
    }

    public Party getPatient() {
        return this.editor.getPatient();
    }

    public Act getEvent() {
        return this.editor.getVisit();
    }

    public User getClinician() {
        return this.editor.getClinician();
    }

    public FlowSheetInfo getFlowSheetInfo() {
        return this.editor.getFlowSheetInfo();
    }

    public Collection<Entity> getTemplates() {
        return this.editor.getTemplates();
    }

    public Act getWeight() {
        return this.editor.getWeightRecord();
    }

    public Act getAppointment() {
        return this.editor.getAppointment();
    }

    public Act getTask() {
        return this.editor.getTask();
    }

    protected void onOK() {
        DefaultValidator validator = new DefaultValidator();
        if (this.editor.validate((Validator)validator)) {
            if (this.save()) {
                super.onOK();
            }
        } else {
            ValidationHelper.showError((Validator)validator);
        }
    }

    protected void doLayout() {
        this.container = ColumnFactory.create((String)"Inset");
        this.getLayout().add((Component)this.container);
        this.setEditor(this.editor);
    }

    CheckInEditor getEditor() {
        return this.editor;
    }

    private void setEditor(CheckInEditor checkInEditor) {
        FocusGroup focus = this.getFocusGroup();
        if (this.editor != checkInEditor) {
            focus.remove(this.editor.getFocusGroup());
            this.container.removeAll();
        }
        this.container.add(checkInEditor.getComponent());
        focus.add(checkInEditor.getFocusGroup());
        this.editor = checkInEditor;
    }

    private boolean save() {
        boolean saved = false;
        try {
            TransactionTemplate template = new TransactionTemplate(this.transactionManager);
            template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    CheckInDialog.this.editor.save();
                }
            });
            saved = true;
        }
        catch (Exception exception) {
            this.revertOnError(exception);
        }
        return saved;
    }

    private void revertOnError(Exception exception) {
        boolean disableSave = false;
        try {
            Act oldAppointment = this.editor.getAppointment();
            CheckInEditor newEditor = this.editor.newInstance();
            Act newAppointment = newEditor.getAppointment();
            if (oldAppointment == null || newAppointment == null || oldAppointment.getStatus().equals(newAppointment.getStatus())) {
                this.setEditor(newEditor);
                log.error("CheckInDialog reverted due to error: " + exception.getMessage(), (Throwable)exception);
                ErrorHelper.show((String)Messages.get((String)"workflow.checkin.error.reverted"));
            } else {
                ErrorHelper.show((String)Messages.get((String)"workflow.checkin.error.updated"), () -> ((CheckInDialog)this).onCancel());
                disableSave = true;
            }
        }
        catch (Exception revertException) {
            log.error("CheckInDialog cannot continue due to error: " + revertException.getMessage(), (Throwable)revertException);
            log.error("CheckInDialog revert cause: " + exception.getMessage(), (Throwable)exception);
            ErrorHelper.show((String)Messages.get((String)"workflow.checkin.error.unrecoverable"), () -> ((CheckInDialog)this).onCancel());
            disableSave = true;
        }
        if (disableSave) {
            this.getButtons().setEnabled("ok", false);
        }
    }
}

