/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.checkin;

import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.smartflow.client.FlowSheetServiceFactory;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.Tasks;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.checkin.NewFlowSheetTask;

public class AddFlowSheetTask
extends Tasks {
    private Act task;
    private final FlowSheetServiceFactory factory;

    public AddFlowSheetTask(FlowSheetServiceFactory factory, HelpContext help) {
        this(null, factory, help);
    }

    public AddFlowSheetTask(Act task, FlowSheetServiceFactory factory, HelpContext help) {
        super(help);
        this.task = task;
        this.factory = factory;
    }

    protected void initialise(TaskContext context) {
        IMObjectBean bean;
        Party workList;
        if (this.task == null) {
            this.task = context.getTask();
        }
        if (this.task != null && (workList = (Party)(bean = this.getBean((IMObject)this.task)).getTarget("worklist", Party.class)) != null && this.createFlowSheet((Entity)workList)) {
            MedicalRecordRules rules = (MedicalRecordRules)ServiceHelper.getBean(MedicalRecordRules.class);
            Act visit = (Act)context.getObject("act.patientClinicalEvent");
            if (visit == null) {
                visit = rules.getEventForAddition(context.getPatient(), this.task.getActivityStartTime(), null, context.getLocation());
            }
            if (visit != null && !visit.isNew()) {
                this.addTask((Task)new NewFlowSheetTask(this.task, visit, true, context.getLocation(), this.factory, context.getHelpContext()));
            }
        }
    }

    private boolean createFlowSheet(Entity workList) {
        IMObjectBean bean = this.getBean((IMObject)workList);
        return bean.getBoolean("createFlowSheet");
    }
}

