/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.sms;

import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import org.openvpms.archetype.rules.workflow.AppointmentReminderConfig;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.sms.service.SMSService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.im.sms.SMSEditor;
import org.openvpms.web.echo.button.CheckBox;
import org.openvpms.web.echo.factory.CheckBoxFactory;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class AppointmentSMSEditor
extends SMSEditor {
    private final AppointmentRules rules;
    private final AppointmentReminderConfig config;
    private final Column replyContainer = ColumnFactory.create((String)"CellSpacing");
    private CheckBox disableReminder;

    public AppointmentSMSEditor(List<Contact> contacts, Variables variables, Context context, SMSService smsService) {
        super(contacts, variables, context, smsService);
        this.rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
        this.config = this.rules.getAppointmentReminderConfig();
        if (this.config != null && this.config.processReplies()) {
            this.addModifiableListener(modifiable -> this.showReplyInfo());
            this.showReplyInfo();
        }
    }

    public void setSource(Act source) {
        super.setSource(source);
        if (source != null && this.rules.sendReminder(source)) {
            this.disableReminder = CheckBoxFactory.create((String)"sms.appointment.disablereminder");
        }
    }

    public boolean disableReminder() {
        return this.disableReminder != null && this.disableReminder.isSelected();
    }

    protected void layout(ComponentGrid grid) {
        super.layout(grid);
        if (this.disableReminder != null) {
            grid.add(new Component[]{LabelFactory.create(), this.disableReminder});
            this.getFocusGroup().add((Component)this.disableReminder);
        }
        if (this.config != null && this.config.processReplies()) {
            grid.add((Component)ColumnFactory.create((String)"InsetY", (Component[])new Component[]{this.replyContainer}), 2);
        }
    }

    private void showReplyInfo() {
        String message = this.getMessage();
        this.replyContainer.removeAll();
        if (this.config.containsConfirmation(message)) {
            this.replyContainer.add((Component)LabelFactory.text((String)Messages.format((String)"sms.appointment.confirm", (Object[])new Object[]{this.config.getConfirmText()})));
        }
        if (this.config.containsCancellation(message)) {
            this.replyContainer.add((Component)LabelFactory.text((String)Messages.format((String)"sms.appointment.cancel", (Object[])new Object[]{this.config.getCancelText()})));
        }
    }
}

