/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.im.act.ActHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.CalendarRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatHelper;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatNTimesCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatUntilDateCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.TimesPredicate;

public class ScheduleEventSeries {
    public static final int DEFAULT_MAX_EVENTS = 365;
    private final Act event;
    private final IArchetypeService service;
    private final int maxEvents;
    private final State current;
    private Act series;
    private List<Act> acts;
    private State previous;
    private boolean updateTimesOnly;

    public ScheduleEventSeries(Act event, IArchetypeService service) {
        this(event, service, 365);
    }

    public ScheduleEventSeries(Act event, IArchetypeService service, int maxEvents) {
        this.event = event;
        this.service = service;
        this.maxEvents = maxEvents;
        IMObjectBean bean = service.getBean((IMObject)event);
        this.series = (Act)bean.getSource("repeat", Act.class);
        if (this.series != null) {
            this.previous = this.createState(bean);
            IMObjectBean seriesBean = service.getBean((IMObject)this.series);
            this.acts = this.getEvents(event, seriesBean);
            this.previous.setExpression(RepeatHelper.getExpression(seriesBean));
            int index = this.acts.indexOf(event);
            this.previous.setCondition(RepeatHelper.getCondition(seriesBean, index));
            this.current = this.copy(this.previous);
        } else {
            this.current = this.createState(bean);
            this.acts = new ArrayList<Act>();
        }
    }

    public Act getEvent() {
        return this.event;
    }

    public void refresh() {
        this.current.update(this.service.getBean((IMObject)this.event));
    }

    public RepeatExpression getExpression() {
        return this.current.getExpression();
    }

    public void setExpression(RepeatExpression expression) {
        this.current.setExpression(expression);
    }

    public RepeatCondition getCondition() {
        return this.current.getCondition();
    }

    public void setCondition(RepeatCondition condition) {
        this.current.setCondition(condition);
    }

    public Overlap getFirstOverlap() {
        return this.calculateSeries(new ArrayList<Times>());
    }

    public void setUpdateTimesOnly(boolean updateTimesOnly) {
        this.updateTimesOnly = updateTimesOnly;
    }

    public boolean isModified() {
        this.refresh();
        return !Objects.equals(this.previous, this.current);
    }

    public void save() {
        this.refresh();
        if (this.isModified()) {
            if (this.previous != null && !this.current.repeats()) {
                this.deleteSeries();
            } else if (this.previous != null) {
                if (!this.previous.repeats() && this.current.repeats()) {
                    this.createEvents();
                } else {
                    this.updateSeries();
                }
            } else if (this.current.repeats()) {
                this.createEvents();
            }
            this.previous = this.copy(this.current);
        }
    }

    public Act getSeries() {
        return this.series;
    }

    public List<Act> getEvents() {
        if (this.series != null) {
            IMObjectBean bean = this.service.getBean((IMObject)this.series);
            return ActHelper.sort((List)bean.getTargets("items", Act.class));
        }
        return Collections.emptyList();
    }

    public List<Times> getEventTimes() {
        ArrayList<Times> result = new ArrayList<Times>();
        result.add(Times.create((Act)this.event));
        Overlap overlap = this.calculateSeries(result);
        return overlap == null ? result : null;
    }

    public Date getStartTime() {
        return this.current.getStartTime();
    }

    public int getMaxEvents() {
        return this.maxEvents;
    }

    protected State copy(State state) {
        return new State(state);
    }

    protected State createState(IMObjectBean bean) {
        return new State(bean);
    }

    protected Act create(Times times, IMObjectBean seriesBean) {
        Act act = (Act)this.service.create(this.event.getArchetype(), Act.class);
        this.populate(act, times, this.current);
        seriesBean.addTarget("items", (IMObject)act, "repeat");
        return act;
    }

    protected IMObjectBean populate(Act act, Times times, State state) {
        act.setActivityStartTime(times.getStartTime());
        act.setActivityEndTime(times.getEndTime());
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setTarget("schedule", state.getSchedule());
        if (!this.updateTimesOnly) {
            this.populate(bean, state);
        }
        return bean;
    }

    protected void populate(IMObjectBean bean, State state) {
    }

    protected boolean canCalculateSeries(State state) {
        return state.getSchedule() != null;
    }

    protected IArchetypeService getService() {
        return this.service;
    }

    private Overlap calculateSeries(List<Times> series) {
        Overlap overlap = null;
        int index = this.acts.indexOf(this.event);
        if (this.current.repeats() && (this.acts.isEmpty() || index >= 0)) {
            Date startTime = this.event.getActivityStartTime();
            Date endTime = this.event.getActivityEndTime();
            Duration duration = new Duration((ReadableInstant)new DateTime((Object)startTime), (ReadableInstant)new DateTime((Object)endTime));
            if (this.canCalculateSeries(this.current)) {
                ArrayList<Times> times = new ArrayList<Times>();
                times.add(Times.create((Act)this.event));
                ListIterator<Act> iterator = index + 1 < this.acts.size() ? this.acts.listIterator(index + 1) : null;
                RepeatExpression expression = this.current.getExpression();
                RepeatCondition condition = this.current.getCondition();
                TimesPredicate max = new TimesPredicate(this.maxEvents - 1);
                Predicate predicate = PredicateUtils.andPredicate(max, condition.create());
                while ((startTime = expression.getRepeatAfter(startTime, (Predicate<Date>)predicate)) != null) {
                    Times newEvent;
                    endTime = new DateTime((Object)startTime).plus((ReadableDuration)duration).toDate();
                    Reference reference = null;
                    if (iterator != null && iterator.hasNext()) {
                        Act act = iterator.next();
                        reference = act.getObjectReference();
                    }
                    if ((overlap = this.getOverlap(times, newEvent = new Times(reference, startTime, endTime))) != null) break;
                    times.add(newEvent);
                    series.add(newEvent);
                }
            }
        }
        return overlap;
    }

    private Overlap getOverlap(List<Times> series, Times event) {
        Overlap overlap = null;
        Comparator comparator = (o1, o2) -> {
            Date startTime1 = o1.getStartTime();
            Date endTime1 = o1.getEndTime();
            Date startTime2 = o2.getStartTime();
            Date endTime2 = o2.getEndTime();
            if (DateRules.compareTo((Date)startTime1, (Date)startTime2) < 0 && DateRules.compareTo((Date)endTime1, (Date)startTime2) <= 0) {
                return -1;
            }
            if (DateRules.compareTo((Date)startTime2, (Date)endTime2) >= 0 && DateRules.compareTo((Date)endTime1, (Date)endTime2) > 0) {
                return 1;
            }
            return Long.compare(o1.getId(), o2.getId());
        };
        int index = Collections.binarySearch(series, event, comparator);
        if (index >= 0) {
            overlap = new Overlap(series.get(index), event);
        }
        return overlap;
    }

    private void createEvents() {
        ArrayList<Times> times = new ArrayList<Times>();
        this.calculateSeries(times);
        this.acts.clear();
        this.acts.add(this.event);
        this.series = this.createSeries();
        IMObjectBean seriesBean = this.populateSeries(this.series, 0);
        ArrayList<Act> toSave = new ArrayList<Act>();
        seriesBean.addTarget("items", (IMObject)this.event, "repeat");
        toSave.add(this.event);
        toSave.add(this.series);
        for (Times t : times) {
            Act act = this.create(t, seriesBean);
            this.acts.add(act);
            toSave.add(act);
        }
        this.service.save(toSave);
    }

    private Act createSeries() {
        this.series = (Act)this.service.create("act.calendarEventSeries", Act.class);
        this.series.setActivityStartTime(this.event.getActivityStartTime());
        return this.series;
    }

    private boolean updateSeries() {
        boolean result;
        ArrayList<Times> times = new ArrayList<Times>();
        Overlap overlap = this.calculateSeries(times);
        if (overlap != null) {
            result = false;
        } else {
            int index = this.acts.indexOf(this.event);
            if (index >= 0) {
                List<Act> future = Collections.emptyList();
                if (index + 1 < this.acts.size()) {
                    future = this.acts.subList(index + 1, this.acts.size());
                }
                this.updateSeries(future, times, index);
                this.acts = new ArrayList<Act>(this.acts.subList(index, this.acts.size()));
                result = true;
            } else {
                result = false;
            }
        }
        return result;
    }

    private void updateSeries(List<Act> acts, List<Times> times, int actsPriorToEvent) {
        Act oldSeries = this.series;
        boolean createSeries = !this.current.repeatEquals(this.previous);
        Act currentSeries = createSeries ? this.createSeries() : this.series;
        IMObjectBean bean = this.populateSeries(currentSeries, actsPriorToEvent);
        IMObjectBean oldBean = createSeries ? this.service.getBean((IMObject)oldSeries) : bean;
        acts = new ArrayList<Act>(acts);
        Iterator<Times> timesIterator = times.iterator();
        ListIterator<Act> iterator = acts.listIterator();
        ArrayList<Act> toSave = new ArrayList<Act>();
        toSave.add(this.event);
        while (timesIterator.hasNext()) {
            Act act;
            if (iterator.hasNext()) {
                act = (Act)iterator.next();
                iterator.remove();
                this.populate(act, timesIterator.next(), this.current);
                if (oldSeries != currentSeries) {
                    this.removeRelationship(oldBean, act);
                    bean.addTarget("items", (IMObject)act, "repeat");
                }
            } else {
                act = this.create(timesIterator.next(), bean);
            }
            toSave.add(act);
        }
        if (oldSeries != currentSeries) {
            this.removeRelationship(oldBean, this.event);
            bean.addTarget("items", (IMObject)this.event, "repeat");
        }
        for (Act act : acts) {
            this.removeRelationship(oldBean, act);
            toSave.add(act);
        }
        if (!toSave.isEmpty()) {
            if (oldSeries != currentSeries) {
                toSave.add(oldSeries);
            }
            toSave.add(currentSeries);
            this.service.save(toSave);
        }
        if (!acts.isEmpty()) {
            for (Act act : acts) {
                this.service.remove((IMObject)act);
            }
        }
    }

    private void removeRelationship(IMObjectBean bean, Act act) {
        ActRelationship relationship = (ActRelationship)bean.removeTarget("items", (IMObject)act);
        if (relationship != null) {
            act.removeActRelationship(relationship);
        }
    }

    private void deleteSeries() {
        int index = this.acts.indexOf(this.event);
        if (index >= 0) {
            List<Act> future = Collections.emptyList();
            if (index + 1 < this.acts.size()) {
                future = this.acts.subList(index + 1, this.acts.size());
            }
            this.deleteSeries(future);
            this.acts.clear();
        }
    }

    private void deleteSeries(List<Act> acts) {
        IMObjectBean bean = this.service.getBean((IMObject)this.series);
        for (Act act : acts) {
            this.removeRelationship(bean, act);
        }
        this.removeRelationship(bean, this.event);
        ArrayList<Act> toSave = new ArrayList<Act>(acts);
        toSave.add(this.series);
        toSave.add(this.event);
        this.service.save(toSave);
        for (Act act : acts) {
            this.service.remove((IMObject)act);
        }
        if (bean.getValues("items", ActRelationship.class).isEmpty()) {
            this.service.remove((IMObject)this.series);
        }
        this.series = null;
    }

    private IMObjectBean populateSeries(Act series, int actsPriorToEvent) {
        IMObjectBean seriesBean = this.service.getBean((IMObject)series);
        String expr = null;
        Integer interval = null;
        String units = null;
        Date endTime = null;
        Integer times = null;
        RepeatExpression expression = this.current.getExpression();
        RepeatCondition condition = this.current.getCondition();
        if (expression instanceof CalendarRepeatExpression) {
            CalendarRepeatExpression calendar = (CalendarRepeatExpression)expression;
            interval = calendar.getInterval();
            units = calendar.getUnits().toString();
        } else {
            expr = ((CronRepeatExpression)expression).getExpression();
        }
        if (condition instanceof RepeatUntilDateCondition) {
            endTime = ((RepeatUntilDateCondition)condition).getDate();
        } else {
            times = ((RepeatNTimesCondition)condition).getTimes() + actsPriorToEvent;
        }
        seriesBean.setValue("interval", (Object)interval);
        seriesBean.setValue("units", (Object)units);
        seriesBean.setValue("expression", (Object)expr);
        seriesBean.setValue("endTime", (Object)endTime);
        seriesBean.setValue("times", (Object)times);
        return seriesBean;
    }

    private List<Act> getEvents(Act event, IMObjectBean series) {
        List items = series.getTargetRefs("items");
        items.remove(event.getObjectReference());
        List result = ActHelper.getActs((Collection)items);
        result.add(event);
        return ActHelper.sort((List)result);
    }

    protected static class State {
        private Date startTime;
        private Date endTime;
        private Reference schedule;
        private RepeatExpression expression;
        private RepeatCondition condition;

        public State(IMObjectBean event) {
            this.update(event);
        }

        public State(State state) {
            this.startTime = state.startTime;
            this.endTime = state.endTime;
            this.schedule = state.schedule;
            this.expression = state.expression;
            this.condition = state.condition;
        }

        public void update(IMObjectBean event) {
            Act act = (Act)event.getObject(Act.class);
            this.startTime = act.getActivityStartTime();
            this.endTime = act.getActivityEndTime();
            this.schedule = event.getTargetRef("schedule");
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public RepeatExpression getExpression() {
            return this.expression;
        }

        public void setExpression(RepeatExpression expression) {
            this.expression = expression;
        }

        public void setCondition(RepeatCondition condition) {
            this.condition = condition;
        }

        public RepeatCondition getCondition() {
            return this.condition;
        }

        public boolean repeats() {
            return this.expression != null && this.condition != null;
        }

        public Reference getSchedule() {
            return this.schedule;
        }

        public boolean repeatEquals(State other) {
            return new EqualsBuilder().append((Object)this.expression, (Object)other.expression).append((Object)this.condition, (Object)other.condition).isEquals();
        }

        public boolean equals(Object obj) {
            boolean result;
            if (obj == this) {
                result = true;
            } else if (!(obj instanceof State)) {
                result = false;
            } else {
                State other = (State)obj;
                result = DateRules.compareTo((Date)this.startTime, (Date)other.startTime) != 0 || DateRules.compareTo((Date)this.endTime, (Date)other.endTime) != 0 ? false : new EqualsBuilder().append((Object)this.schedule, (Object)other.schedule).append((Object)this.expression, (Object)other.expression).append((Object)this.condition, (Object)other.condition).isEquals();
            }
            return result;
        }
    }

    public static class Overlap {
        private final Times event1;
        private final Times event2;

        public Overlap(Times event1, Times event2) {
            this.event1 = event1;
            this.event2 = event2;
        }

        public Times getEvent1() {
            return this.event1;
        }

        public Times getEvent2() {
            return this.event2;
        }
    }
}

