/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.button.ToggleButton;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;

class RepeatOnDaysEditor
extends AbstractRepeatExpressionEditor {
    private ToggleButton[] days = new ToggleButton[7];

    public RepeatOnDaysEditor(Date startTime) {
        super(startTime);
        String[] weekdays = DateFormatSymbols.getInstance().getShortWeekdays();
        for (int i = 0; i < this.days.length; ++i) {
            int day = 1 + i;
            String name = weekdays[day];
            this.days[i] = new ToggleButton(name, false);
        }
        if (startTime != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(startTime);
            this.days[calendar.get(7) - 1].setSelected(true);
        }
    }

    public RepeatOnDaysEditor(CronRepeatExpression expression) {
        this((Date)null);
        CronRepeatExpression.DayOfWeek dayOfWeek = expression.getDayOfWeek();
        for (int i = 0; i < this.days.length; ++i) {
            int day = 1 + i;
            if (!dayOfWeek.isSelected(day) && !dayOfWeek.equals(CronRepeatExpression.DayOfWeek.ALL)) continue;
            this.days[i].setSelected(true);
        }
    }

    @Override
    public Component getComponent() {
        Row row = new Row();
        row.setCellSpacing(new Extent(1));
        FocusGroup group = this.getFocusGroup();
        for (ToggleButton day : this.days) {
            row.add((Component)day);
            group.add((Component)day);
        }
        Label every = LabelFactory.create((String)"workflow.scheduling.appointment.every");
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{every, row});
    }

    public static boolean supports(CronRepeatExpression expression) {
        CronRepeatExpression.DayOfWeek dayOfWeek = expression.getDayOfWeek();
        CronRepeatExpression.DayOfMonth dayOfMonth = expression.getDayOfMonth();
        CronRepeatExpression.Month month = expression.getMonth();
        return !dayOfWeek.isOrdinal() && dayOfMonth.isAll() && month.isAll();
    }

    @Override
    public RepeatExpression getExpression() {
        ArrayList<String> list = new ArrayList<String>();
        Date startTime = this.getStartTime();
        if (startTime != null) {
            for (int i = 0; i < this.days.length; ++i) {
                boolean selected = this.days[i].isSelected();
                if (!selected) continue;
                String day = CronRepeatExpression.DayOfWeek.getDay(1 + i);
                list.add(day);
            }
            if (!list.isEmpty()) {
                CronRepeatExpression.DayOfWeek dayOfWeek = CronRepeatExpression.DayOfWeek.days(list);
                return new CronRepeatExpression(startTime, dayOfWeek);
            }
        }
        return null;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        for (ToggleButton button : this.days) {
            if (!button.isSelected()) continue;
            return true;
        }
        validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"workflow.scheduling.appointment.selectdays")));
        return false;
    }
}

