/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.component.bound.SpinBox;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.CalendarRepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatHelper;

class RepeatEveryEditor
extends AbstractRepeatExpressionEditor {
    private SimpleProperty interval = new SimpleProperty("interval", null, Integer.class, Messages.get((String)"workflow.scheduling.appointment.interval"));
    private final DateUnits units;

    public RepeatEveryEditor(DateUnits units) {
        this.units = units;
    }

    public RepeatEveryEditor(CalendarRepeatExpression expression) {
        this.interval.setValue((Object)expression.getInterval());
        this.units = expression.getUnits();
    }

    @Override
    public Component getComponent() {
        Label every = LabelFactory.create((String)"workflow.scheduling.appointment.every");
        Label label = LabelFactory.create();
        String unitText = RepeatHelper.toString(this.units);
        label.setText(unitText);
        SpinBox field = new SpinBox((Property)this.interval, 1, 999);
        this.getFocusGroup().add((Component)field);
        return RowFactory.create((String)"CellSpacing", (Component[])new Component[]{every, field, label});
    }

    @Override
    public RepeatExpression getExpression() {
        return new CalendarRepeatExpression(this.interval.getInt(), this.units);
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean result = this.interval.validate(validator);
        if (result) {
            boolean bl = result = this.interval.getInt() > 0;
            if (!result) {
                String message = Messages.get((String)"workflow.scheduling.appointment.invalidInterval");
                validator.add((Modifiable)this.interval, new ValidatorError((Property)this.interval, message));
            }
        }
        return result;
    }
}

