/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.util.Date;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatHelper;

public class CalendarRepeatExpression
implements RepeatExpression {
    private final int interval;
    private DateUnits units;

    public CalendarRepeatExpression(int interval, DateUnits units) {
        this.interval = interval;
        this.units = units;
    }

    public int getInterval() {
        return this.interval;
    }

    public DateUnits getUnits() {
        return this.units;
    }

    public String toString() {
        String result;
        if (this.interval == 1) {
            result = RepeatHelper.toString(this.getType());
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append(Messages.get((String)"workflow.scheduling.appointment.every"));
            buffer.append(" ");
            buffer.append(this.interval);
            buffer.append(" ");
            buffer.append(RepeatHelper.toString(this.units));
            result = buffer.toString();
        }
        return result;
    }

    @Override
    public RepeatExpression.Type getType() {
        if (this.interval == 1) {
            switch (this.units) {
                case DAYS: {
                    return RepeatExpression.Type.DAILY;
                }
                case WEEKS: {
                    return RepeatExpression.Type.WEEKLY;
                }
                case MONTHS: {
                    return RepeatExpression.Type.MONTHLY;
                }
                case YEARS: {
                    return RepeatExpression.Type.YEARLY;
                }
            }
        }
        return RepeatExpression.Type.CUSTOM;
    }

    @Override
    public Date getRepeatAfter(Date time, Predicate<Date> condition) {
        Date date = DateRules.getDate((Date)time, (int)this.interval, (DateUnits)this.units);
        return condition.evaluate((Object)date) ? date : null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CalendarRepeatExpression) {
            CalendarRepeatExpression other = (CalendarRepeatExpression)obj;
            return this.interval == other.interval && this.units == other.units;
        }
        return false;
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        return builder.append(this.interval).append((Object)this.units).hashCode();
    }
}

