/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.repeat;

import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.GregorianCalendar;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.web.component.bound.BoundSelectFieldFactory;
import org.openvpms.web.component.bound.SpinBox;
import org.openvpms.web.component.im.list.PairListModel;
import org.openvpms.web.component.property.NumericPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.repeat.AbstractRepeatExpressionEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.CronRepeatExpression;

public abstract class AbstractRepeatOnNthDayEditor
extends AbstractRepeatExpressionEditor {
    private final SimpleProperty ordinal = new SimpleProperty("ordinal", String.class);
    private final SimpleProperty day = new SimpleProperty("day", String.class);
    private final SimpleProperty interval = new SimpleProperty("interval", null, Integer.class, Messages.get((String)"workflow.scheduling.appointment.interval"));

    public AbstractRepeatOnNthDayEditor(Date startTime) {
        this();
        this.setStartTime(startTime);
        if (startTime != null) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(startTime);
            this.day.setValue((Object)CronRepeatExpression.DayOfWeek.getDay(calendar.get(7)));
            this.ordinal.setValue((Object)calendar.get(8));
        }
    }

    public AbstractRepeatOnNthDayEditor(CronRepeatExpression expression) {
        this();
        CronRepeatExpression.DayOfWeek dayOfWeek = expression.getDayOfWeek();
        this.day.setValue((Object)dayOfWeek.getDay());
        if (dayOfWeek.getOrdinal() == -1) {
            this.ordinal.setValue((Object)"L");
        } else {
            this.ordinal.setValue((Object)dayOfWeek.getOrdinal());
        }
    }

    private AbstractRepeatOnNthDayEditor() {
        this.ordinal.setRequired(true);
        this.day.setRequired(true);
        this.interval.setRequired(true);
        this.interval.setTransformer((PropertyTransformer)new NumericPropertyTransformer((Property)this.interval, true));
        this.interval.setValue((Object)1);
    }

    public void setInterval(int interval) {
        this.interval.setValue((Object)interval);
    }

    public int getInterval() {
        return this.interval.getInt();
    }

    public CronRepeatExpression.DayOfWeek getDayOfWeek() {
        CronRepeatExpression.DayOfWeek result = null;
        String nth = this.ordinal.getString();
        String d = this.day.getString();
        if (nth != null && d != null) {
            result = "L".equals(nth) ? CronRepeatExpression.DayOfWeek.last(d) : CronRepeatExpression.DayOfWeek.nth(d, Integer.parseInt(nth));
        }
        return result;
    }

    protected SelectField createOrdinalSelector() {
        PairListModel ordinalModel = new PairListModel();
        ordinalModel.add((Object)"1", (Object)Messages.get((String)"workflow.scheduling.appointment.first"));
        ordinalModel.add((Object)"2", (Object)Messages.get((String)"workflow.scheduling.appointment.second"));
        ordinalModel.add((Object)"3", (Object)Messages.get((String)"workflow.scheduling.appointment.third"));
        ordinalModel.add((Object)"4", (Object)Messages.get((String)"workflow.scheduling.appointment.fourth"));
        ordinalModel.add((Object)"5", (Object)Messages.get((String)"workflow.scheduling.appointment.fifth"));
        ordinalModel.add((Object)"L", (Object)Messages.get((String)"workflow.scheduling.appointment.last"));
        SelectField ordinalField = BoundSelectFieldFactory.create((Property)this.ordinal, (ListModel)ordinalModel);
        ordinalField.setCellRenderer(PairListModel.RENDERER);
        return ordinalField;
    }

    protected SelectField createDaySelector() {
        PairListModel dayModel = new PairListModel();
        String[] weekdays = DateFormatSymbols.getInstance().getWeekdays();
        for (int i = 0; i < 7; ++i) {
            int day = 1 + i;
            String name = weekdays[day];
            dayModel.add((Object)CronRepeatExpression.DayOfWeek.getDay(day), (Object)name);
        }
        SelectField dayField = BoundSelectFieldFactory.create((Property)this.day, (ListModel)dayModel);
        dayField.setCellRenderer(PairListModel.RENDERER);
        return dayField;
    }

    protected SpinBox createIntervalField() {
        return new SpinBox((Property)this.interval, 1, 12);
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return this.ordinal.validate(validator) && this.day.validate(validator) && this.interval.validate(validator);
    }
}

