/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.boarding;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayScheduleGrid;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageRow;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageScheduleGroup;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;

public class CageScheduleGrid
extends AbstractMultiDayScheduleGrid {
    private final Set<CageScheduleGroup> groups;
    private List<CageRow> rows = new ArrayList<CageRow>();

    public CageScheduleGrid(Entity scheduleView, Date date, int days, Map<Entity, ScheduleEvents> appointments, AppointmentRules rules) {
        super(scheduleView, date, days, appointments, rules);
        this.groups = new LinkedHashSet<CageScheduleGroup>();
        CageScheduleGroup schedulesWithOutCageType = new CageScheduleGroup(null);
        HashMap<Entity, CageScheduleGroup> groupsByCageType = new HashMap<Entity, CageScheduleGroup>();
        for (Schedule schedule : this.getSchedules()) {
            CageScheduleGroup group;
            if (schedule.getCageType() != null) {
                group = (CageScheduleGroup)groupsByCageType.get(schedule.getCageType());
                if (group == null) {
                    group = new CageScheduleGroup(schedule.getCageType());
                    groupsByCageType.put(schedule.getCageType(), group);
                }
            } else {
                group = schedulesWithOutCageType;
            }
            group.add(schedule);
            this.groups.add(group);
        }
        this.layout();
    }

    public Set<CageScheduleGroup> getGroups() {
        return this.groups;
    }

    public int getScheduleCount() {
        int result = 0;
        for (CageScheduleGroup group : this.groups) {
            result += group.getScheduleCount();
        }
        return result;
    }

    public CageScheduleGroup getGroup(Reference cageType) {
        for (CageScheduleGroup group : this.groups) {
            if (group.getCageType() == null || !Objects.equals(group.getCageType().getObjectReference(), cageType)) continue;
            return group;
        }
        return null;
    }

    public List<CageRow> getRows() {
        return this.rows;
    }

    public CageRow getCageSchedule(int row) {
        return row < this.rows.size() ? this.rows.get(row) : null;
    }

    public boolean expand(CageScheduleGroup group, boolean expand) {
        boolean changed = false;
        if (group.isExpanded() != expand) {
            group.setExpanded(expand);
            changed = true;
            this.layout();
        }
        return changed;
    }

    private void layout() {
        this.rows.clear();
        this.rows.add(new CageRow());
        for (CageScheduleGroup group : this.groups) {
            this.rows.add(new CageRow(group, null));
            if (!group.isExpanded()) continue;
            for (Schedule schedule : group.getSchedules()) {
                this.rows.add(new CageRow(group, schedule));
            }
        }
    }
}

