/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment.boarding;

import java.util.HashSet;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Table;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractMultiDayTableCellRenderer;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageRow;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageScheduleGroup;
import org.openvpms.web.workspace.workflow.appointment.boarding.CageTableModel;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;

public class AbstractCageTableCellRenderer
extends AbstractMultiDayTableCellRenderer {
    public AbstractCageTableCellRenderer(CageTableModel model) {
        super(model);
    }

    @Override
    protected CageTableModel getModel() {
        return (CageTableModel)super.getModel();
    }

    @Override
    protected Component getComponent(Table table, Object value, int column, int row) {
        Component result = value instanceof CageRow ? this.getFreeSlots((CageRow)value, column) : super.getComponent(table, value, column, row);
        return result;
    }

    protected Component getFreeSlots(CageRow cageRow, int column) {
        int free = 0;
        CageTableModel model = this.getModel();
        int slot = model.getSlot(column, 0);
        if (cageRow.isTotal()) {
            for (CageScheduleGroup group : model.getGrid().getGroups()) {
                free += this.getFreeSlots(group, model, slot);
            }
        } else {
            free = this.getFreeSlots(cageRow.getGroup(), model, slot);
        }
        Label label = TableHelper.rightAlign((String)Integer.toString(free));
        label.setStyleName("bold");
        TableHelper.mergeStyle((Component)label, (String)"ScheduleTable.Even");
        return label;
    }

    private int getFreeSlots(CageScheduleGroup group, CageTableModel model, int slot) {
        int free = 0;
        HashSet<Entity> seen = new HashSet<Entity>();
        for (Schedule schedule : group.getSchedules()) {
            Entity entity = schedule.getSchedule();
            if (seen.contains(entity)) continue;
            seen.add(entity);
            if (model.getAvailability(schedule, slot) != ScheduleEventGrid.Availability.FREE) continue;
            ++free;
        }
        return free;
    }
}

