/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableCellRenderer;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.TableFactory;
import org.openvpms.web.echo.table.Cell;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractAppointmentTableCellRender;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.AppointmentTableHeaderRenderer;
import org.openvpms.web.workspace.workflow.appointment.AppointmentTableModel;
import org.openvpms.web.workspace.workflow.appointment.SingleScheduleTableCellRenderer;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleColours;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

class SingleScheduleTableModel
extends AppointmentTableModel {
    private String[] columnNames;
    private static final int STATUS_INDEX = 1;
    private static final int APPOINTMENT_INDEX = 2;
    private static final int CUSTOMER_INDEX = 3;
    private static final int PATIENT_INDEX = 4;
    private static final int REASON_INDEX = 5;
    private static final int NOTES_INDEX = 6;
    private static final String[] NODE_NAMES = new String[]{"startTime", "status", "appointmentType", "customer", "patient", "reason", "notes"};

    public SingleScheduleTableModel(AppointmentGrid grid, Context context, ScheduleColours colours) {
        super(grid, context, colours);
    }

    public boolean isMarked(int column, int row) {
        Cell cell = this.getMarked();
        if (row != -1 && column != -1 && cell != null && row == cell.getRow()) {
            ScheduleTableModel.ScheduleColumn col = this.getColumns().get(column);
            return col.getModelIndex() != 0;
        }
        return false;
    }

    public Object getValueAt(int column, int row) {
        Object result = null;
        AppointmentGrid grid = this.getGrid();
        ScheduleTableModel.Column c = this.getColumn(column);
        if (c.getModelIndex() == 0) {
            result = grid.getStartTime(row);
        } else {
            PropertySet set = this.getEvent(column, row);
            int rowSpan = 1;
            Schedule schedule = this.getSchedule(column, row);
            if (set != null) {
                result = Schedule.isBlockingEvent(set) ? this.getBlock(set, (TableColumn)c) : this.getAppointment(set, (TableColumn)c);
                rowSpan = grid.getSlots(set, schedule, row);
            } else if (schedule != null && grid.getAvailability(schedule, row) == ScheduleEventGrid.Availability.UNAVAILABLE) {
                rowSpan = grid.getUnavailableSlots(schedule, row);
            }
            if (rowSpan > 1) {
                if (!(result instanceof Component)) {
                    Label label = LabelFactory.create();
                    if (result != null) {
                        label.setText(result.toString());
                    }
                    result = label;
                }
                ((Component)result).setLayoutData((LayoutData)TableFactory.rowSpan((int)rowSpan));
            }
        }
        return result;
    }

    protected Object getAppointment(PropertySet set, TableColumn column) {
        String result = null;
        int index = column.getModelIndex();
        switch (index) {
            case 1: {
                result = this.getStatus(set);
                break;
            }
            case 5: {
                result = set.getString("act.reasonName");
                if (result != null) break;
                result = set.getString("act.reason");
                break;
            }
            case 6: {
                result = LabelFactory.text((String)set.getString("notes"));
                break;
            }
            case 2: {
                result = this.getViewer(set, "scheduleType.objectReference", "scheduleType.name", false);
                break;
            }
            case 3: {
                result = this.getCustomer(set);
                break;
            }
            case 4: {
                result = this.getViewer(set, "patient.objectReference", "patient.name", true);
            }
        }
        return result;
    }

    protected Object getBlock(PropertySet set, TableColumn column) {
        String result = null;
        int index = column.getModelIndex();
        switch (index) {
            case 6: {
                result = set.getString("notes");
                break;
            }
            case 2: {
                result = this.getViewer(set, "scheduleType.objectReference", "scheduleType.name", false);
            }
        }
        return result;
    }

    @Override
    protected TableColumnModel createColumnModel(ScheduleEventGrid grid) {
        DefaultTableColumnModel result = new DefaultTableColumnModel();
        List<Schedule> schedules = grid.getSchedules();
        Schedule schedule = schedules.get(0);
        String[] names = this.getColumnNames();
        ScheduleTableModel.ScheduleColumn startTime = new ScheduleTableModel.ScheduleColumn(0, schedule, names[0]);
        startTime.setHeaderRenderer(AppointmentTableHeaderRenderer.INSTANCE);
        startTime.setCellRenderer((TableCellRenderer)new AppointmentTableModel.TimeColumnCellRenderer());
        result.addColumn((TableColumn)startTime);
        SingleScheduleTableCellRenderer renderer = new SingleScheduleTableCellRenderer(this);
        for (int i = 1; i < names.length; ++i) {
            ScheduleTableModel.ScheduleColumn column = new ScheduleTableModel.ScheduleColumn(i, schedule, names[i]);
            column.setHeaderRenderer(AppointmentTableHeaderRenderer.INSTANCE);
            column.setCellRenderer((TableCellRenderer)renderer);
            result.addColumn((TableColumn)column);
        }
        return result;
    }

    protected String getDisplayName(ArchetypeDescriptor archetype, String name) {
        NodeDescriptor descriptor = archetype.getNodeDescriptor(name);
        return descriptor != null ? descriptor.getDisplayName() : null;
    }

    private Component getCustomer(PropertySet event) {
        Component result = this.getViewer(event, "customer.objectReference", "customer.name", true);
        return AbstractAppointmentTableCellRender.addAppointmentIcons(result, event);
    }

    private String[] getColumnNames() {
        if (this.columnNames == null) {
            this.columnNames = new String[NODE_NAMES.length];
            this.columnNames[0] = Messages.get((String)"workflow.scheduling.table.time");
            ArchetypeDescriptor archetype = ServiceHelper.getArchetypeService().getArchetypeDescriptor("act.customerAppointment");
            if (archetype != null) {
                for (int i = 1; i < NODE_NAMES.length; ++i) {
                    this.columnNames[i] = this.getDisplayName(archetype, NODE_NAMES[i]);
                }
            }
        }
        return this.columnNames;
    }
}

