/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.workspace.workflow.appointment.AbstractAppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.Slot;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;

public class SingleScheduleGrid
extends AbstractAppointmentGrid {
    private final Schedule schedule;
    private final List<ScheduleSlot> slots = new ArrayList<ScheduleSlot>();

    SingleScheduleGrid(Entity scheduleView, Date date, Entity organisationSchedule, ScheduleEvents events, AppointmentRules rules, RosterService rosterService) {
        super(scheduleView, date, -1, -1, rules, rosterService);
        this.schedule = this.createSchedule(organisationSchedule);
        this.setSchedules(Collections.singletonList(this.schedule));
        int startMins = this.schedule.getStartMins();
        int endMins = this.schedule.getEndMins();
        int slotSize = this.schedule.getSlotSize();
        this.setSlotSize(slotSize);
        for (PropertySet set : events.getEvents()) {
            Date startTime = set.getDate("act.startTime");
            Date endTime = set.getDate("act.endTime");
            int slotStart = this.getSlotMinutes(startTime, false);
            int slotEnd = this.getSlotMinutes(endTime, true);
            if (startMins > slotStart) {
                startMins = slotStart;
            }
            if (endMins >= slotEnd) continue;
            endMins = slotEnd;
        }
        this.setStartMins(startMins);
        this.setEndMins(endMins);
        this.setEvents(events);
    }

    @Override
    public int getSlots() {
        return this.slots.size();
    }

    @Override
    public PropertySet getEvent(Schedule schedule, int slot) {
        PropertySet result = null;
        if (slot >= 0 && slot < this.getSlots()) {
            SlotGroup group = this.slots.get(slot).getGroup();
            result = group != null ? group.getAppointment() : null;
        }
        return result;
    }

    @Override
    public int getSlots(PropertySet event, Schedule schedule, int slot) {
        SlotGroup group = this.slots.get(slot).getGroup();
        int result = 0;
        if (group != null) {
            int start = group.getStartSlot();
            result = start + group.getSlots() - slot;
        }
        return result;
    }

    @Override
    public List<Slot> getSlotTimes() {
        return this.slots;
    }

    private void setEvents(ScheduleEvents events) {
        int startMins = this.getStartMins();
        int endMins = this.getEndMins();
        int slotSize = this.getSlotSize();
        ZonedDateTime end = this.getSlotTimeForMinutes(endMins);
        ZonedDateTime slotStart = this.getSlotTimeForMinutes(startMins);
        while (slotStart.compareTo(end) < 0) {
            ZonedDateTime slotEnd = slotStart.plusMinutes(slotSize);
            if (slotEnd.compareTo(end) > 0) {
                slotEnd = end;
            }
            this.slots.add(new ScheduleSlot(slotStart, slotEnd));
            slotStart = slotEnd;
        }
        for (PropertySet event : events.getEvents()) {
            this.addEvent(event);
        }
    }

    private void addEvent(PropertySet event) {
        this.schedule.addEvent(event);
        Date startTime = event.getDate("act.startTime");
        Date endTime = event.getDate("act.endTime");
        int startSlot = this.getSlot(startTime);
        int endSlot = this.getSlot(endTime, true);
        SlotGroup group = new SlotGroup(event, startSlot, endSlot - startSlot);
        for (int i = startSlot; i < endSlot && i < this.slots.size(); ++i) {
            ScheduleSlot scheduleSlot = this.slots.get(i);
            if (scheduleSlot.getGroup() != null) {
                throw new IllegalStateException("Overlapping event detected, slot=" + i + ", start=" + scheduleSlot.getStart());
            }
            scheduleSlot.setGroup(group);
        }
    }

    private static class SlotGroup {
        private final PropertySet appointment;
        private final int start;
        private final int slots;

        SlotGroup(PropertySet appointment, int start, int slots) {
            this.appointment = appointment;
            this.start = start;
            this.slots = slots;
        }

        public PropertySet getAppointment() {
            return this.appointment;
        }

        int getStartSlot() {
            return this.start;
        }

        int getSlots() {
            return this.slots;
        }
    }

    private static class ScheduleSlot
    extends Slot {
        private SlotGroup group;

        ScheduleSlot(ZonedDateTime start, ZonedDateTime end) {
            this(start, end, null);
        }

        ScheduleSlot(ZonedDateTime start, ZonedDateTime end, SlotGroup group) {
            super(start, end);
            this.group = group;
        }

        public void setGroup(SlotGroup group) {
            this.group = group;
        }

        SlotGroup getGroup() {
            return this.group;
        }
    }
}

