/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.AbstractIMObjectEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.workflow.appointment.OnlineBookingTimesLayoutStrategy;

public class OnlineBookingTimesEditor
extends AbstractIMObjectEditor {
    public OnlineBookingTimesEditor(IMObject object, IMObject parent, LayoutContext layoutContext) {
        super(object, parent, layoutContext);
    }

    protected boolean doValidation(Validator validator) {
        return super.doValidation(validator) && this.validateTimes(validator);
    }

    private boolean validateTimes(Validator validator) {
        boolean valid = true;
        for (String prefix : OnlineBookingTimesLayoutStrategy.DAY_PREFIXES) {
            Property open = this.getProperty(prefix + "Open");
            if (open.getBoolean()) {
                Property start = this.getProperty(prefix + "StartTime");
                Property end = this.getProperty(prefix + "EndTime");
                Date startTime = start.getDate();
                Date endTime = end.getDate();
                if (startTime == null) {
                    valid = this.reportRequired(start, validator);
                } else if (endTime == null) {
                    valid = this.reportRequired(end, validator);
                } else if (startTime.compareTo(endTime) >= 0) {
                    String message = Messages.format((String)"workflow.scheduling.onlinebooking.invalidtimes", (Object[])new Object[]{start.getDisplayName(), end.getDisplayName()});
                    validator.add((Modifiable)this, new ValidatorError(message));
                    valid = false;
                }
            }
            if (!valid) break;
        }
        return valid;
    }
}

