/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.list.DefaultListModel;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.AppointmentService;
import org.openvpms.archetype.rules.workflow.FreeSlotQuery;
import org.openvpms.archetype.rules.workflow.Slot;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.cache.MapIMObjectCache;
import org.openvpms.web.component.bound.BoundSelectFieldFactory;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.bound.BoundTimeField;
import org.openvpms.web.component.bound.BoundTimeFieldFactory;
import org.openvpms.web.component.im.clinician.ClinicianReferenceEditor;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.query.DateRange;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.TimePropertyTransformer;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AppointmentHelper;
import org.openvpms.web.workspace.workflow.appointment.AppointmentSchedules;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleQuery;

class FreeAppointmentSlotQuery
extends ScheduleQuery {
    private final Date date;
    private final Property fromTime;
    private final Property toTime;
    private final Property duration;
    private final Property durationUnits;
    private final ClinicianReferenceEditor clinician;
    private final IArchetypeService service;
    private final Component cageLabelContainer = new Row();
    private final Component cageContainer = new Row();
    private DateRange dateRange;
    private SelectField cageSelector;

    FreeAppointmentSlotQuery(Party location, Entity view, Entity schedule, Date date, Preferences prefs, LayoutContext layoutContext) {
        super(new AppointmentSchedules(location, prefs));
        this.date = date;
        this.fromTime = this.createTime("fromTime", Messages.get((String)"workflow.scheduling.appointment.find.fromTime"));
        this.toTime = this.createTime("toTime", Messages.get((String)"workflow.scheduling.appointment.find.toTime"));
        this.duration = new SimpleProperty("duration", null, Integer.class, Messages.get((String)"workflow.scheduling.appointment.find.duration"));
        this.durationUnits = new SimpleProperty("duration", null, DateUnits.class);
        SimpleProperty clinicianProperty = new SimpleProperty("clinician", Reference.class);
        clinicianProperty.setDisplayName(DescriptorHelper.getDisplayName((String)"act.customerAppointment", (String)"clinician", (ArchetypeService)ServiceHelper.getArchetypeService()));
        clinicianProperty.setArchetypeRange(new String[]{"security.user"});
        this.clinician = new ClinicianReferenceEditor((Property)clinicianProperty, null, layoutContext);
        this.service = ServiceHelper.getArchetypeService();
        this.setScheduleView(view);
        this.setSchedule(schedule);
    }

    @Override
    public void setSchedule(Entity schedule) {
        super.setSchedule(schedule);
        if (schedule != null) {
            IMObjectBean bean = this.service.getBean((IMObject)schedule);
            this.duration.setValue((Object)bean.getInt("slotSize"));
            this.durationUnits.setValue((Object)DateUnits.valueOf((String)bean.getString("slotUnits")));
        } else {
            int minSlotSize = 0;
            String minSlotUnits = DateUnits.MINUTES.toString();
            int minSlotMinutes = 0;
            for (Entity entity : this.getSelectedSchedules()) {
                int slotMinutes;
                IMObjectBean bean = this.service.getBean((IMObject)entity);
                int slotSize = bean.getInt("slotSize");
                String units = bean.getString("slotUnits");
                int n = slotMinutes = DateUnits.HOURS.name().equals(units) ? 60 * slotSize : slotSize;
                if (minSlotSize != 0 && slotMinutes >= minSlotMinutes) continue;
                minSlotSize = slotSize;
                minSlotUnits = units;
                minSlotMinutes = slotMinutes;
            }
            this.duration.setValue((Object)minSlotSize);
            this.durationUnits.setValue((Object)DateUnits.valueOf((String)minSlotUnits));
        }
    }

    @Override
    public void setScheduleView(Entity view) {
        super.setScheduleView(view);
    }

    public Iterator<Slot> query() {
        FreeSlotQuery query = new FreeSlotQuery((IArchetypeService)ServiceHelper.getArchetypeService(), (AppointmentService)ServiceHelper.getBean(AppointmentService.class), (RosterService)ServiceHelper.getBean(RosterService.class), (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class));
        List<Entity> schedules = this.getSelectedSchedules();
        query.setSchedules(schedules.toArray(new Entity[0]));
        query.setClinician((User)this.clinician.getObject());
        Entity cageType = null;
        if (this.cageSelector != null) {
            cageType = (Entity)this.cageSelector.getSelectedItem();
        }
        query.setCageType(cageType);
        Date from = this.dateRange.getFrom();
        Date now = new Date();
        if (from == null || DateRules.compareTo((Date)from, (Date)now) < 0) {
            from = this.getNextSlot(now);
        }
        query.setFromDate(from);
        Date to = this.dateRange.getTo();
        if (to == null || DateRules.compareTo((Date)to, (Date)from) < 0) {
            to = from;
        }
        to = DateRules.getDate((Date)to, (int)1, (DateUnits)DateUnits.DAYS);
        query.setToDate(to);
        query.setFromTime(this.getPeriod(this.fromTime));
        query.setToTime(this.getPeriod(this.toTime));
        query.setMinSlotSize(this.duration.getInt(), this.getDurationUnits());
        return query.query();
    }

    @Override
    protected Component createContainer() {
        return GridFactory.create((int)8);
    }

    @Override
    protected void updateViewSchedules() {
        super.updateViewSchedules();
        this.updateCageTypes();
    }

    @Override
    protected void doLayout(Component container) {
        super.doLayout(container);
        this.dateRange = new DateRange(false);
        this.dateRange.setContainer(container);
        if (this.date != null) {
            this.dateRange.setFrom(this.date);
        } else {
            this.dateRange.setFrom(new Date());
        }
        this.dateRange.setTo(DateRules.getDate((Date)this.dateRange.getFrom(), (int)1, (DateUnits)DateUnits.MONTHS));
        FocusGroup group = this.getFocusGroup();
        group.add(this.dateRange.getFocusGroup());
        this.addTime(this.fromTime, container);
        this.addTime(this.toTime, container);
        Label durationLabel = LabelFactory.create();
        durationLabel.setText(this.duration.getDisplayName());
        container.add((Component)durationLabel);
        TextField durationField = BoundTextComponentFactory.createNumeric((Property)this.duration, (int)5);
        SelectField unitsField = this.createDurationUnits();
        group.add((Component)durationField);
        group.add((Component)unitsField);
        container.add((Component)RowFactory.create((String)"CellSpacing", (Component[])new Component[]{durationField, unitsField}));
        container.add((Component)LabelFactory.create());
        container.add((Component)LabelFactory.create());
        container.add((Component)LabelFactory.text((String)this.clinician.getProperty().getDisplayName()));
        container.add(this.clinician.getComponent());
        container.add(this.cageLabelContainer);
        container.add(this.cageContainer);
    }

    private void addTime(Property property, Component container) {
        Label label = LabelFactory.create();
        label.setText(property.getDisplayName());
        container.add((Component)label);
        BoundTimeField field = BoundTimeFieldFactory.create((Property)property);
        container.add((Component)field);
        this.getFocusGroup().add((Component)field);
    }

    private Property createTime(String name, String displayName) {
        SimpleProperty property = new SimpleProperty(name, null, Date.class, displayName);
        TimePropertyTransformer transformer = new TimePropertyTransformer((Property)property);
        property.setTransformer((PropertyTransformer)transformer);
        return property;
    }

    private Period getPeriod(Property property) {
        Date date = property.getDate();
        return date != null ? new Period((long)new DateTime((Object)date).getMillisOfDay()) : null;
    }

    private DateUnits getDurationUnits() {
        String code = this.durationUnits.getString();
        return code != null ? DateUnits.valueOf((String)code) : DateUnits.MINUTES;
    }

    private SelectField createDurationUnits() {
        EnumSet<DateUnits> units = EnumSet.range(DateUnits.MINUTES, DateUnits.WEEKS);
        DefaultListModel model = new DefaultListModel(units.toArray());
        SelectField result = BoundSelectFieldFactory.create((Property)this.durationUnits, (ListModel)model);
        result.setCellRenderer((ListCellRenderer & Serializable)(component, o, i) -> {
            String label = null;
            DateUnits unit = (DateUnits)o;
            switch (unit) {
                case MINUTES: {
                    label = Messages.get((String)"workflow.scheduling.appointment.find.minutes");
                    break;
                }
                case HOURS: {
                    label = Messages.get((String)"workflow.scheduling.appointment.find.hours");
                    break;
                }
                case DAYS: {
                    label = Messages.get((String)"workflow.scheduling.appointment.find.days");
                    break;
                }
                case WEEKS: {
                    label = Messages.get((String)"workflow.scheduling.appointment.find.weeks");
                }
            }
            return label;
        });
        result.setSelectedIndex(0);
        return result;
    }

    private Date getNextSlot(Date time) {
        int slotSize = 15;
        DateTime dt = new DateTime((Object)time);
        int min = dt.getMinuteOfHour() / slotSize * slotSize;
        if (dt.getMinuteOfHour() % slotSize != 0 && (min += slotSize) >= 60) {
            dt = dt.plusHours(1);
            min = 0;
        }
        Date from = dt.withMinuteOfHour(min).minuteOfDay().roundFloorCopy().toDate();
        return from;
    }

    private void updateCageTypes() {
        Map cageTypes;
        if (AppointmentHelper.isMultiDayView(this.getScheduleView())) {
            cageTypes = new HashMap();
            IArchetypeRuleService service = ServiceHelper.getArchetypeService();
            MapIMObjectCache cache = new MapIMObjectCache(cageTypes, (ArchetypeService)service);
            for (Entity schedule : this.getSelectedSchedules()) {
                IMObjectBean bean = service.getBean((IMObject)schedule);
                cache.get(bean.getTargetRef("cageType"));
            }
        } else {
            cageTypes = Collections.emptyMap();
        }
        if (cageTypes.isEmpty()) {
            this.cageSelector = null;
            this.cageLabelContainer.removeAll();
            this.cageContainer.removeAll();
        } else {
            ArrayList objects = new ArrayList(cageTypes.values());
            objects.sort(IMObjectSorter.getNameComparator((boolean)true));
            IMObjectListModel model = new IMObjectListModel(objects, true, false);
            this.cageSelector = SelectFieldFactory.create((ListModel)model);
            this.cageSelector.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
            this.cageSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    FreeAppointmentSlotQuery.this.onQuery();
                }
            });
            if (this.cageLabelContainer.getComponentCount() == 0) {
                this.cageLabelContainer.add((Component)LabelFactory.create((String)"workflow.scheduling.appointment.find.cagetype"));
            }
            this.cageContainer.removeAll();
            this.cageContainer.add((Component)this.cageSelector);
        }
    }
}

