/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Row;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.event.ActionEvent;
import org.joda.time.DateTime;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.ScheduleEvents;
import org.openvpms.archetype.rules.workflow.ScheduleService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.im.query.DateNavigator;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AppointmentHelper;
import org.openvpms.web.workspace.workflow.appointment.AppointmentSchedules;
import org.openvpms.web.workspace.workflow.appointment.TimeRange;
import org.openvpms.web.workspace.workflow.appointment.TimeRangeSelector;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleServiceQuery;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleTableModel;

class AppointmentQuery
extends ScheduleServiceQuery {
    private final Component datesLabelContainer = new Row();
    private final Component datesContainer = new Row();
    private final Component showLabelContainer = new Row();
    private final Component showContainer = new Row();
    private TimeRangeSelector timeSelector;
    private SelectField dateSelector;
    private DateRange dateRange = DateRange.DAY;
    private int days = 1;
    private Show show = Show.ALL;
    private SelectField showSelector;

    public AppointmentQuery(Party location, Preferences prefs) {
        super(ServiceHelper.getAppointmentService(), new AppointmentSchedules(location, prefs), prefs);
        String showPref = prefs.getString("entity.preferenceGroupScheduling", "show", Show.ALL.toString());
        try {
            this.show = Show.valueOf(showPref);
        }
        catch (Exception exception) {
            this.show = Show.ALL;
        }
    }

    @Override
    public void setScheduleView(Entity view) {
        super.setScheduleView(view);
        this.updateDatesFilter();
    }

    public TimeRange getTimeRange() {
        return this.timeSelector.getSelected();
    }

    public void setTimeRange(TimeRange range) {
        this.timeSelector.setSelected(range);
    }

    public DateRange getDateRange() {
        return this.dateRange;
    }

    public int getDays() {
        return this.days;
    }

    public Show getShow() {
        return this.show;
    }

    @Override
    protected Component createContainer() {
        return GridFactory.create((int)8);
    }

    @Override
    protected void doLayout(Component container) {
        super.doLayout(container);
        this.timeSelector = this.createTimeSelector();
        Object[] dwm = new String[]{Messages.get((String)"workflow.scheduling.dates.day"), Messages.get((String)"workflow.scheduling.dates.week"), Messages.get((String)"workflow.scheduling.dates.fortnight"), Messages.get((String)"workflow.scheduling.dates.month")};
        this.dateSelector = SelectFieldFactory.create((Object[])dwm);
        this.dateSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AppointmentQuery.this.onDatesChanged();
            }
        });
        Object[] show = new String[]{Messages.get((String)"workflow.scheduling.show.all"), Messages.get((String)"workflow.scheduling.show.cage"), Messages.get((String)"workflow.scheduling.show.summary"), Messages.get((String)"workflow.scheduling.show.checkin"), Messages.get((String)"workflow.scheduling.show.checkout")};
        this.showSelector = SelectFieldFactory.create((Object[])show);
        this.showSelector.setSelectedIndex(this.show.ordinal());
        this.showSelector.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AppointmentQuery.this.onShowChanged();
            }
        });
        container.add((Component)LabelFactory.create((String)"workflow.scheduling.time"));
        container.add((Component)this.timeSelector);
        this.getFocusGroup().add((Component)this.timeSelector);
        container.add(this.datesLabelContainer, 6);
        container.add(this.datesContainer, 7);
        container.add(this.showLabelContainer, 14);
        container.add(this.showContainer, 15);
        this.updateDatesFilter();
    }

    @Override
    protected ScheduleEvents getEvents(Entity schedule, Date date) {
        ScheduleService service = this.getService();
        if (this.days == 1) {
            return service.getScheduleEvents(schedule, date);
        }
        return service.getScheduleEvents(schedule, date, DateRules.getDate((Date)date, (int)this.days, (DateUnits)DateUnits.DAYS));
    }

    @Override
    protected boolean updated(Entity schedule, ScheduleEvents events, Date date) {
        if (this.days == 1) {
            return super.updated(schedule, events, date);
        }
        ScheduleService service = this.getService();
        long hash = service.getModHash(schedule, date, DateRules.getDate((Date)date, (int)this.days, (DateUnits)DateUnits.DAYS));
        return hash == -1L || hash != events.getModHash();
    }

    @Override
    protected Reference getDefaultClinician() {
        return this.getPreferences().getReference("entity.preferenceGroupScheduling", "clinician", null);
    }

    @Override
    protected ScheduleTableModel.Highlight getDefaultHighlight() {
        ScheduleTableModel.Highlight result = null;
        String highlight = this.getPreferences().getString("entity.preferenceGroupScheduling", "highlight", null);
        if (highlight != null) {
            try {
                result = ScheduleTableModel.Highlight.valueOf(highlight);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    protected void onViewChanged() {
        this.updateDatesFilter();
        super.onViewChanged();
    }

    @Override
    protected void updateViewSchedules() {
        super.updateViewSchedules();
        this.updateShowSelector();
    }

    @Override
    protected void onDateChanged() {
        this.updateDays(this.getDate(), this.dateRange);
        super.onDateChanged();
    }

    private void onDatesChanged() {
        int index = this.dateSelector.getSelectedIndex();
        DateRange range = index >= 0 && index < DateRange.values().length ? DateRange.values()[index] : DateRange.DAY;
        this.setDateRange(range);
        this.getPreferences().setPreference("entity.preferenceGroupScheduling", "dates", (Object)range.toString());
        this.onQuery();
    }

    @Override
    protected void onCurrentDateSelected() {
        this.onNow();
    }

    private TimeRangeSelector createTimeSelector() {
        TimeRange range;
        TimeRangeSelector field = new TimeRangeSelector();
        String select = this.getPreferences().getString("entity.preferenceGroupScheduling", "time", "ALL");
        DateTime now = new DateTime();
        switch (select) {
            case "AM_PM": {
                range = TimeRange.getAMorPM(now);
                break;
            }
            case "M_A_E": {
                range = TimeRange.getMorningOrAfternoonOrEvening(now);
                break;
            }
            default: {
                range = TimeRange.ALL;
            }
        }
        field.setSelected(range);
        field.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                AppointmentQuery.this.onQuery();
            }
        });
        return field;
    }

    private void setDateRange(DateRange dateRange) {
        this.dateRange = dateRange;
        switch (dateRange) {
            case DAY: {
                this.setDateNavigator(DateNavigator.DAY);
                break;
            }
            case WEEK: {
                this.setDateNavigator(DateNavigator.WEEK);
                break;
            }
            case FORTNIGHT: {
                this.setDateNavigator(DateNavigator.FORTNIGHT);
                break;
            }
            case MONTH: {
                this.setDateNavigator(DateNavigator.MONTH);
            }
        }
        this.updateDays(this.getDate(), dateRange);
    }

    private void onShowChanged() {
        int index = this.showSelector.getSelectedIndex();
        if (index >= 0 && index < Show.values().length) {
            this.show = Show.values()[index];
            this.getPreferences().setPreference("entity.preferenceGroupScheduling", "show", (Object)this.show.toString());
            this.onQuery();
        }
    }

    private void updateShowSelector() {
        boolean hasCageType = false;
        if (this.show == Show.CAGE) {
            for (Entity schedule : this.getSelectedSchedules()) {
                IMObjectBean bean = IMObjectHelper.getBean((IMObject)schedule);
                if (bean.getTargetRef("cageType") == null) continue;
                hasCageType = true;
                break;
            }
            if (!hasCageType) {
                this.show = Show.ALL;
                this.showSelector.setSelectedIndex(this.show.ordinal());
            }
        }
    }

    private void updateDays(Date date, DateRange range) {
        switch (range) {
            case DAY: {
                this.days = 1;
                break;
            }
            case WEEK: {
                this.days = 7;
                break;
            }
            case FORTNIGHT: {
                this.days = 14;
                break;
            }
            default: {
                this.days = DateRules.getDaysInMonth((Date)date);
            }
        }
    }

    private void updateDatesFilter() {
        DateRange range;
        Entity view = this.getScheduleView();
        if (AppointmentHelper.isMultiDayView(view)) {
            String datesPref = this.getPreferences().getString("entity.preferenceGroupScheduling", "dates", DateRange.FORTNIGHT.toString());
            try {
                range = DateRange.valueOf(datesPref);
            }
            catch (Exception exception) {
                range = DateRange.FORTNIGHT;
            }
            if (this.datesContainer.getComponentCount() == 0) {
                this.datesLabelContainer.add((Component)LabelFactory.create((String)"workflow.scheduling.dates"));
                this.datesContainer.add((Component)this.dateSelector);
            }
            if (this.showContainer.getComponentCount() == 0) {
                this.showLabelContainer.add((Component)LabelFactory.create((String)"workflow.scheduling.show"));
                this.showContainer.add((Component)this.showSelector);
            }
        } else {
            range = DateRange.DAY;
            this.datesLabelContainer.removeAll();
            this.datesContainer.removeAll();
            this.showLabelContainer.removeAll();
            this.showContainer.removeAll();
        }
        this.setDateRange(range);
        this.dateSelector.setSelectedIndex(this.dateRange.ordinal());
    }

    public static enum Show {
        ALL,
        CAGE,
        SUMMARY,
        CHECKIN,
        CHECKOUT;

    }

    public static enum DateRange {
        DAY,
        WEEK,
        FORTNIGHT,
        MONTH;

    }
}

