/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import com.google.common.collect.Range;
import com.google.common.collect.TreeRangeSet;
import java.util.Date;
import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Row;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.Period;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.AppointmentService;
import org.openvpms.archetype.rules.workflow.ScheduleArchetypes;
import org.openvpms.archetype.rules.workflow.ScheduleTimes;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.alert.AlertManager;
import org.openvpms.web.component.bound.BoundCheckBox;
import org.openvpms.web.component.bound.BoundDateTimeField;
import org.openvpms.web.component.bound.BoundDateTimeFieldFactory;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.edit.PropertyEditor;
import org.openvpms.web.component.im.clinician.ClinicianParticipationEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ParticipationEditor;
import org.openvpms.web.component.im.layout.ArchetypeNodes;
import org.openvpms.web.component.im.layout.ComponentSet;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.sms.SMSHelper;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.ComponentState;
import org.openvpms.web.component.property.MutablePropertySet;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertySet;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.echo.focus.FocusHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.alert.AlertSummary;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditor;
import org.openvpms.web.workspace.workflow.appointment.AppointmentAlertSummary;
import org.openvpms.web.workspace.workflow.appointment.AppointmentTypeParticipationEditor;
import org.openvpms.web.workspace.workflow.appointment.repeat.AppointmentSeries;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeries;

public class AppointmentEditor
extends AbstractCalendarEventEditor {
    private final AppointmentRules rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
    private final boolean smsPractice;
    private final Period noReminder;
    private final BoundCheckBox sendReminder;
    private final boolean customerPatientReadOnly;
    private Row alerts;
    private boolean scheduleReminders;
    private boolean appointmentTypeReminders;
    private String rosterAlert;
    private static final String BOOKING_NOTES = "bookingNotes";
    private static final String APPOINTMENT_TYPE = "appointmentType";
    private static final String CLINICIAN = "clinician";
    private static final String LOCATION = "location";
    private static final String STATUS = "status";
    private static final String CONFIRMED_TIME = "confirmedTime";
    private static final String ARRIVAL_TIME = "arrivalTime";
    private static final String REASON = "reason";

    public AppointmentEditor(Act act, IMObject parent, LayoutContext context) {
        this(act, parent, false, context);
    }

    public AppointmentEditor(Act act, IMObject parent, boolean editSeries, LayoutContext context) {
        super(act, parent, editSeries, context);
        if (act.isNew()) {
            this.initParticipant("customer", (IMObject)context.getContext().getCustomer());
        }
        Entity appointmentType = this.getAppointmentType();
        Entity schedule = this.getSchedule();
        this.smsPractice = SMSHelper.isSMSEnabled((Party)this.getLayoutContext().getContext().getPractice());
        this.scheduleReminders = this.rules.isRemindersEnabled(schedule);
        this.noReminder = this.rules.getNoReminderPeriod();
        this.getSeries().setNoReminderPeriod(this.noReminder);
        if (appointmentType == null && schedule != null) {
            appointmentType = this.getDefaultAppointmentType(schedule);
            this.setAppointmentType(appointmentType);
        }
        this.appointmentTypeReminders = this.rules.isRemindersEnabled(appointmentType);
        this.getProperty(STATUS).addModifiableListener(modifiable -> this.onStatusChanged());
        this.customerPatientReadOnly = this.makeCustomerPatientReadOnly();
        this.getProperty("sendReminder").addModifiableListener(modifiable -> this.onSendReminderChanged());
        this.sendReminder = new BoundCheckBox(this.getProperty("sendReminder"));
        this.addStartEndTimeListeners();
        if (act.isNew()) {
            this.updateSendReminder(true);
        }
        this.checkRoster();
    }

    public void setAppointmentType(Entity appointmentType) {
        this.setParticipant(APPOINTMENT_TYPE, appointmentType);
        this.updateReason();
    }

    public Entity getAppointmentType() {
        return this.getParticipant(APPOINTMENT_TYPE);
    }

    public User getClinician() {
        return (User)this.getParticipant(CLINICIAN);
    }

    public Party getLocation() {
        Party location = null;
        Entity schedule = this.getSchedule();
        if (schedule != null) {
            IMObjectBean bean = this.getBean((IMObject)schedule);
            location = (Party)this.getObject(bean.getTargetRef(LOCATION));
        }
        return location;
    }

    public IMObjectEditor newInstance() {
        boolean editSeries = this.getSeriesEditor() != null;
        return new AppointmentEditor((Act)this.reload((IMObject)this.getObject()), this.getParent(), editSeries, this.getLayoutContext());
    }

    @Override
    public AppointmentSeries getSeries() {
        return (AppointmentSeries)super.getSeries();
    }

    public void setAlertListener(AlertListener listener) {
        super.setAlertListener(listener);
        this.checkRoster();
    }

    public String getReason() {
        return this.getProperty(REASON).getString();
    }

    public void setReason(String reason) {
        this.getProperty(REASON).setValue((Object)reason);
    }

    @Override
    protected ScheduleEventSeries createSeries() {
        return new AppointmentSeries(this.getObject(), this.getService());
    }

    @Override
    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new AppointmentLayoutStrategy();
    }

    @Override
    protected void onLayoutCompleted() {
        super.onLayoutCompleted();
        Entity schedule = this.getSchedule();
        this.initSchedule(schedule);
        this.getAppointmentTypeEditor().addModifiableListener(modifiable -> this.onAppointmentTypeChanged());
        this.getClinicianEditor().addModifiableListener(modifiable -> this.checkRoster());
        if (this.getEndTime() == null) {
            this.calculateEndTime();
        }
        this.updateAlerts();
    }

    @Override
    protected void onStartTimeChanged() {
        super.onStartTimeChanged();
        this.updateSendReminder(this.sendReminder.isSelected());
        this.checkRoster();
    }

    @Override
    protected void onEndTimeChanged() {
        super.onEndTimeChanged();
        this.checkRoster();
    }

    @Override
    protected void onCustomerChanged() {
        super.onCustomerChanged();
        this.updateSendReminder(true);
        this.getProperty("reminderSent").setValue(null);
        this.getProperty("reminderError").setValue(null);
        this.updateAlerts();
    }

    @Override
    protected void onPatientChanged() {
        super.onPatientChanged();
        this.updateAlerts();
    }

    @Override
    protected void calculateEndTime() {
        Date start = this.getStartTime();
        Entity schedule = this.getSchedule();
        AppointmentTypeParticipationEditor editor = this.getAppointmentTypeEditor();
        Entity appointmentType = editor.getEntity();
        if (start != null && schedule != null && appointmentType != null) {
            Date end = this.rules.calculateEndTime(start, schedule, appointmentType);
            this.setEndTime(end);
        }
    }

    @Override
    protected void onScheduleChanged(Entity schedule) {
        super.onScheduleChanged(schedule);
        this.updateSendReminder(this.sendReminder.isSelected());
        this.checkRoster();
    }

    @Override
    protected void initSchedule(Entity schedule) {
        super.initSchedule(schedule);
        AppointmentTypeParticipationEditor editor = this.getAppointmentTypeEditor();
        editor.setSchedule(schedule);
        this.scheduleReminders = schedule != null && this.rules.isRemindersEnabled(schedule);
    }

    @Override
    protected boolean doValidation(Validator validator) {
        return this.validateCustomer(validator) && super.doValidation(validator) && this.validatePatient(validator);
    }

    protected boolean makeCustomerPatientReadOnly() {
        IMObjectBean bean = this.getBean((IMObject)this.getObject());
        return bean.getTargetRef("event") != null || !bean.getValues("tasks").isEmpty();
    }

    private void checkRoster() {
        AlertListener listener = this.getAlertListener();
        Party location = this.getLocation();
        Entity schedule = this.getSchedule();
        if (listener != null && location != null && schedule != null && this.rules.checkRoster(this.getObject(), location)) {
            User clinician;
            if (this.rosterAlert != null) {
                listener.cancel(this.rosterAlert);
                this.rosterAlert = null;
            }
            if ((clinician = this.getClinician()) != null) {
                Date startTime = this.getStartTime();
                Date endTime = this.getEndTime();
                RosterService service = (RosterService)ServiceHelper.getBean(RosterService.class);
                List events = service.getUserEvents(clinician, location, startTime, endTime);
                if (events.isEmpty()) {
                    String message = Messages.format((String)"workflow.scheduling.appointment.notrostered", (Object[])new Object[]{clinician.getName()});
                    this.rosterAlert = listener.onAlert(message);
                } else {
                    TreeRangeSet set = TreeRangeSet.create();
                    set.add(Range.closed((Comparable)startTime, (Comparable)endTime));
                    for (RosterService.UserEvent event : events) {
                        if (!this.hasSchedule(event.getArea(), schedule)) continue;
                        set.remove(Range.closed((Comparable)event.getStartTime(), (Comparable)event.getEndTime()));
                    }
                    if (!set.isEmpty()) {
                        String message = Messages.format((String)"workflow.scheduling.appointment.partiallyrostered", (Object[])new Object[]{clinician.getName()});
                        this.rosterAlert = listener.onAlert(message);
                    } else {
                        Act exclude;
                        AppointmentService appointmentService = (AppointmentService)ServiceHelper.getBean(AppointmentService.class);
                        List appointments = appointmentService.getAppointmentsForClinician(clinician, startTime, endTime, exclude = this.getObject().isNew() ? null : this.getObject());
                        if (!appointments.isEmpty()) {
                            String scheduleName = IMObjectHelper.getName((Reference)((ScheduleTimes)appointments.get(0)).getSchedule());
                            String message = Messages.format((String)"workflow.scheduling.appointment.alreadyscheduled", (Object[])new Object[]{clinician.getName(), scheduleName});
                            this.rosterAlert = listener.onAlert(message);
                        }
                    }
                }
            }
        }
    }

    private boolean hasSchedule(Reference areaRef, Entity schedule) {
        Entity area = (Entity)this.getObject(areaRef);
        return area != null && this.rules.rosterAreaHasSchedule(area, schedule);
    }

    private ClinicianParticipationEditor getClinicianEditor() {
        ParticipationEditor result = this.getParticipationEditor(CLINICIAN, true);
        return (ClinicianParticipationEditor)result;
    }

    private boolean validateCustomer(Validator validator) {
        boolean result = true;
        if (this.getCustomer() == null) {
            result = this.reportRequired("customer", validator);
        }
        return result;
    }

    private boolean validatePatient(Validator validator) {
        boolean result = true;
        String status = this.getStatus();
        if (!("PENDING".equals(status) || "NO_SHOW".equals(status) || "CONFIRMED".equals(status) || "CANCELLED".equals(status) || this.getPatient() != null)) {
            result = this.reportRequired("patient", validator);
        }
        return result;
    }

    private void updateAlerts() {
        Component container = this.getAlertsContainer();
        container.removeAll();
        Component alerts = this.createAlerts();
        if (alerts != null) {
            container.add(alerts);
        }
    }

    private Component createAlerts() {
        Row result = null;
        Component customerSummary = null;
        Component patientSummary = null;
        Party customer = this.getCustomer();
        Party patient = this.getPatient();
        if (customer != null) {
            customerSummary = this.getCustomerAlerts(customer);
        }
        if (patient != null) {
            patientSummary = this.getPatientAlerts(patient);
        }
        if (customerSummary != null || patientSummary != null) {
            result = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
            if (customerSummary != null) {
                result.add(customerSummary);
            }
            if (patientSummary != null) {
                result.add(patientSummary);
            }
            result = RowFactory.create((String)"Inset", (Component[])new Component[]{result});
        }
        return result;
    }

    private Component getCustomerAlerts(Party customer) {
        AlertSummary alerts = this.getAlertSummary(customer, "alerts.customer");
        return alerts != null ? alerts.getComponent() : null;
    }

    private Component getPatientAlerts(Party patient) {
        AlertSummary alerts = this.getAlertSummary(patient, "alerts.patient");
        return alerts != null ? alerts.getComponent() : null;
    }

    private AlertSummary getAlertSummary(Party party, String key) {
        AppointmentAlertSummary result = null;
        LayoutContext context = this.getLayoutContext();
        List alerts = ((AlertManager)ServiceHelper.getBean(AlertManager.class)).getAlerts(party);
        if (!alerts.isEmpty()) {
            result = new AppointmentAlertSummary(party, alerts, key, context.getContext(), context.getHelpContext());
        }
        return result;
    }

    private void onAppointmentTypeChanged() {
        try {
            this.calculateEndTime();
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
        this.appointmentTypeReminders = this.rules.isRemindersEnabled(this.getAppointmentType());
        this.updateReason();
        this.updateSendReminder(true);
    }

    private void updateReason() {
        Entity appointmentType = this.getAppointmentType();
        if (appointmentType != null) {
            Component focus = FocusHelper.getFocus();
            IMObjectBean bean = this.getBean((IMObject)appointmentType);
            Lookup reason = (Lookup)bean.getObject(REASON, Lookup.class);
            if (reason != null) {
                this.setReason(reason.getCode());
            } else if (this.getReason() == null && (reason = ServiceHelper.getLookupService().getDefaultLookup(ScheduleArchetypes.VISIT_REASONS)) != null) {
                this.setReason(reason.getCode());
            }
            if (focus != null) {
                FocusHelper.setFocus((Component)focus);
            }
        }
    }

    private void onStatusChanged() {
        String status = (String)this.getProperty(STATUS).getValue();
        if ("PENDING".equals(status)) {
            this.getProperty(CONFIRMED_TIME).setValue(null);
            this.getProperty(ARRIVAL_TIME).setValue(null);
        } else if ("CONFIRMED".equals(status)) {
            this.getProperty(CONFIRMED_TIME).setValue((Object)new Date());
        } else if ("CHECKED_IN".equals(status)) {
            this.getProperty(ARRIVAL_TIME).setValue((Object)new Date());
        }
    }

    private void onSendReminderChanged() {
        if (this.getProperty("sendReminder").getBoolean()) {
            this.getProperty("reminderSent").setValue(null);
            this.onLayout();
        }
    }

    private AppointmentTypeParticipationEditor getAppointmentTypeEditor() {
        ParticipationEditor result = this.getParticipationEditor(APPOINTMENT_TYPE, true);
        return (AppointmentTypeParticipationEditor)result;
    }

    private Entity getDefaultAppointmentType(Entity schedule) {
        return this.rules.getDefaultAppointmentType(schedule);
    }

    private Component getAlertsContainer() {
        if (this.alerts == null) {
            this.alerts = new Row();
        }
        return this.alerts;
    }

    private void updateSendReminder(boolean select) {
        boolean enabled;
        Date startTime = this.getStartTime();
        Date now = new Date();
        Party customer = this.getCustomer();
        boolean bl = enabled = this.smsPractice && this.scheduleReminders && this.appointmentTypeReminders && this.noReminder != null && customer != null && startTime != null && startTime.after(now) && SMSHelper.canSMS((Party)customer);
        if (!enabled) {
            this.sendReminder.setSelected(false);
        }
        this.sendReminder.setEnabled(enabled);
        if (enabled && select) {
            if (this.getObject().isNew()) {
                Date to = DateRules.plus((Date)now, (Period)this.noReminder);
                select = startTime.after(to);
            }
            this.sendReminder.setSelected(select);
        }
    }

    private class AppointmentLayoutStrategy
    extends AbstractCalendarEventEditor.LayoutStrategy {
        public AppointmentLayoutStrategy() {
            ArchetypeNodes archetypeNodes = this.getArchetypeNodes();
            archetypeNodes.excludeIfEmpty(new String[]{"reminderSent", "reminderError", AppointmentEditor.BOOKING_NOTES});
            if (!AppointmentEditor.this.smsPractice || !AppointmentEditor.this.scheduleReminders) {
                archetypeNodes.exclude(new String[]{"sendReminder"});
            } else {
                this.addComponent(new ComponentState((Component)AppointmentEditor.this.sendReminder, AppointmentEditor.this.sendReminder.getProperty()));
            }
            BoundDateTimeField reminderSent = BoundDateTimeFieldFactory.create((Property)AppointmentEditor.this.getProperty("reminderSent"));
            reminderSent.setStyleName("edit");
            this.addComponent(new ComponentState((PropertyEditor)reminderSent));
        }

        @Override
        public ComponentState apply(IMObject object, PropertySet properties, IMObject parent, LayoutContext context) {
            Property bookingNotes;
            if (AppointmentEditor.this.customerPatientReadOnly) {
                MutablePropertySet mutableProperties = new MutablePropertySet(properties);
                mutableProperties.setReadOnly("customer");
                mutableProperties.setReadOnly("patient");
                properties = mutableProperties;
            }
            if (!StringUtils.isEmpty((CharSequence)(bookingNotes = AppointmentEditor.this.getProperty(AppointmentEditor.BOOKING_NOTES)).getString())) {
                this.addComponent(this.createMultiLineText(bookingNotes, 2, 10, new Extent(50, 128), context));
            }
            return super.apply(object, properties, parent, context);
        }

        protected void doLayout(IMObject object, PropertySet properties, IMObject parent, Component container, LayoutContext context) {
            super.doLayout(object, properties, parent, container, context);
            container.add(AppointmentEditor.this.getAlertsContainer());
        }

        protected Component getDefaultFocus(ComponentSet components) {
            return components.getFocusable("customer");
        }
    }
}

