/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.openvpms.archetype.rules.workflow.AppointmentService;
import org.openvpms.archetype.rules.workflow.CalendarBlock;
import org.openvpms.archetype.rules.workflow.CalendarBlocks;
import org.openvpms.archetype.rules.workflow.Times;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditDialog;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditor;
import org.openvpms.web.workspace.workflow.appointment.OverlappingCalendarEventDialog;
import org.openvpms.web.workspace.workflow.appointment.OverlappingEvents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppointmentEditDialog
extends AbstractCalendarEventEditDialog {
    private final AppointmentService appointmentService = (AppointmentService)ServiceHelper.getBean(AppointmentService.class);
    private Party customer;
    private static final int MAX_OVERLAPS = 25;
    private static final Logger log = LoggerFactory.getLogger(AppointmentEditDialog.class);

    public AppointmentEditDialog(AbstractCalendarEventEditor editor, Context context) {
        super(editor, context);
    }

    @Override
    protected void getState() {
        super.getState();
        this.customer = this.getEditor().getCustomer();
    }

    @Override
    protected boolean noTimeCheckRequired() {
        boolean result = super.noTimeCheckRequired();
        if (result) {
            Party newCustomer = this.getEditor().getCustomer();
            result = Objects.equals(newCustomer, this.customer);
        }
        return result;
    }

    @Override
    protected boolean checkEventTimes(List<Times> times, final boolean close) {
        OverlappingEvents overlaps;
        boolean result = true;
        AbstractCalendarEventEditor editor = this.getEditor();
        Entity schedule = editor.getSchedule();
        Party customer = editor.getCustomer();
        if (schedule != null && customer != null && (overlaps = this.getOverlappingEvents(times, schedule)) != null) {
            if (!overlaps.allowDoubleBooking() && overlaps.getFirstAppointment() != null) {
                this.displayOverlapError(overlaps.getFirstAppointment());
                result = false;
            } else {
                CalendarBlocks blocks = overlaps.getCalendarBlocks(customer);
                if (blocks != null && blocks.getReserved() != null) {
                    this.displayReservedCalendarBlockError(blocks.getReserved());
                    result = false;
                }
                if (result) {
                    List unreservedBlocks;
                    result = false;
                    List<Times> appointments = overlaps.getAppointments();
                    List list = unreservedBlocks = blocks != null ? blocks.getUnreserved() : Collections.emptyList();
                    if (overlaps.getEvents().size() > 25) {
                        String title = Messages.get((String)"workflow.scheduling.toomanyoverlaps.title");
                        String message = Messages.get((String)"workflow.scheduling.toomanyoverlaps.message");
                        ErrorDialog.show((String)title, (String)message);
                    } else {
                        this.logOverlap(times, overlaps);
                        String title = Messages.get((String)"workflow.scheduling.overlap.title");
                        String message = Messages.get((String)"workflow.scheduling.overlap.message");
                        OverlappingCalendarEventDialog dialog = new OverlappingCalendarEventDialog(title, message, appointments, unreservedBlocks);
                        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                            public void onOK() {
                                if (AppointmentEditDialog.this.save()) {
                                    if (close) {
                                        AppointmentEditDialog.this.close("ok");
                                    } else {
                                        AppointmentEditDialog.this.getState();
                                    }
                                }
                            }
                        });
                        dialog.show();
                    }
                }
            }
        }
        return result;
    }

    private void logOverlap(List<Times> events, OverlappingEvents overlaps) {
        Times overlap = overlaps.getFirstOverlap();
        if (overlap != null) {
            for (Times event : events) {
                if (!event.intersects(overlap.getStartTime(), overlap.getEndTime())) continue;
                log.error("Overlap: reference=" + event.getReference() + ", from=" + DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(event.getStartTime()) + ", to=" + DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(event.getEndTime()) + " overlaps reference=" + overlap.getReference() + ", from=" + DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(overlap.getStartTime()) + ", to=" + DateFormatUtils.ISO_8601_EXTENDED_DATETIME_FORMAT.format(overlap.getEndTime()));
                break;
            }
        }
    }

    private OverlappingEvents getOverlappingEvents(List<Times> events, Entity schedule) {
        List overlaps = this.appointmentService.getOverlappingEvents(events, schedule, 26);
        return overlaps != null ? new OverlappingEvents(schedule, overlaps, (IArchetypeService)ServiceHelper.getArchetypeService()) : null;
    }

    private void displayReservedCalendarBlockError(CalendarBlock block) {
        String displayName = DescriptorHelper.getDisplayName((IMObject)this.getEvent(), (ArchetypeService)ServiceHelper.getArchetypeService());
        String title = Messages.format((String)"workflow.scheduling.reserved.title", (Object[])new Object[]{displayName});
        StringBuilder buffer = new StringBuilder();
        ArrayList types = new ArrayList();
        types.addAll(block.getCustomerAccountTypes());
        types.addAll(block.getCustomerTypes());
        types.sort(IMObjectSorter.getNameComparator((boolean)true));
        for (Lookup type : types) {
            if (buffer.length() != 0) {
                buffer.append(", ");
            }
            buffer.append(type.getName());
        }
        String message = Messages.format((String)"workflow.scheduling.reserved.message", (Object[])new Object[]{displayName, block.getName(), DateFormatter.formatDate((Date)block.getStartTime(), (boolean)false), DateFormatter.formatTime((Date)block.getStartTime(), (boolean)false), buffer});
        ErrorHelper.show((String)title, (String)message);
    }
}

