/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.util.Date;
import java.util.List;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.hl7.patient.PatientContext;
import org.openvpms.hl7.patient.PatientInformationService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.sms.SMSHelper;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.component.workflow.Workflow;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.InformationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.patient.info.PatientContextHelper;
import org.openvpms.web.workspace.workflow.LocalClinicianContext;
import org.openvpms.web.workspace.workflow.WorkflowFactory;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditDialog;
import org.openvpms.web.workspace.workflow.appointment.AbstractCalendarEventEditor;
import org.openvpms.web.workspace.workflow.appointment.AppointmentBrowser;
import org.openvpms.web.workspace.workflow.appointment.AppointmentEditor;
import org.openvpms.web.workspace.workflow.appointment.CalendarBlockEditor;
import org.openvpms.web.workspace.workflow.appointment.CopySeriesDialog;
import org.openvpms.web.workspace.workflow.appointment.DeleteSeriesDialog;
import org.openvpms.web.workspace.workflow.appointment.EditSeriesDialog;
import org.openvpms.web.workspace.workflow.appointment.MoveSeriesDialog;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatCondition;
import org.openvpms.web.workspace.workflow.appointment.repeat.RepeatExpression;
import org.openvpms.web.workspace.workflow.appointment.repeat.ScheduleEventSeriesState;
import org.openvpms.web.workspace.workflow.appointment.sms.AppointmentSMSDialog;
import org.openvpms.web.workspace.workflow.checkin.TransferWorkflow;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleCRUDWindow;

public class AppointmentCRUDWindow
extends ScheduleCRUDWindow {
    private final AppointmentBrowser browser;
    private final AppointmentRules rules;
    private String oldStatus;
    private static final String BLOCK_ID = "button.block";
    private static final String CONFIRM_ID = "button.confirm";
    private static final String CHECKIN_ID = "button.checkin";
    private static final String REMIND_ID = "button.sms.remind";
    private static final String TRANSFER_ID = "button.transfer";
    private static final Archetypes<Act> BLOCK = Archetypes.create((String)"act.calendarBlock", Act.class);

    public AppointmentCRUDWindow(AppointmentBrowser browser, Context context, HelpContext help) {
        this(browser, AppointmentActions.INSTANCE, context, help);
    }

    protected AppointmentCRUDWindow(AppointmentBrowser browser, AppointmentActions actions, Context context, HelpContext help) {
        super((Archetypes<Act>)Archetypes.create((String)"act.customerAppointment", Act.class, (String)Messages.get((String)"workflow.scheduling.createtype")), actions, context, help);
        this.browser = browser;
        browser.setListener(() -> this.enableButtons(this.getButtons(), this.getObject() != null));
        this.rules = (AppointmentRules)ServiceHelper.getBean(AppointmentRules.class);
    }

    public void setObject(Act object) {
        super.setObject((IMObject)object);
        this.getContext().setAppointment(object);
    }

    public void create() {
        if (this.canCreateAppointment()) {
            super.create();
        }
    }

    public void cut() {
        if (this.browser.isAppointmentsSelected()) {
            this.browser.clearMarked();
            PropertySet selected = this.browser.getSelected();
            Act event = this.browser.getAct(selected);
            if (event != null) {
                if (TypeHelper.isA((IMObject)event, (String)"act.calendarBlock") || "PENDING".equals(event.getStatus()) || "CONFIRMED".equals(event.getStatus())) {
                    this.browser.setMarked(selected, true);
                } else {
                    InformationDialog.show((String)Messages.get((String)"workflow.scheduling.appointment.cut.title"), (String)Messages.get((String)"workflow.scheduling.appointment.cut.pending"));
                }
            } else {
                InformationDialog.show((String)Messages.get((String)"workflow.scheduling.appointment.cut.title"), (String)Messages.get((String)"workflow.scheduling.appointment.cut.select"));
            }
        }
    }

    public void paste() {
        if (this.browser.isAppointmentsSelected()) {
            if (this.browser.getMarked() == null) {
                InformationDialog.show((String)Messages.get((String)"workflow.scheduling.appointment.paste.title"), (String)Messages.get((String)"workflow.scheduling.appointment.paste.select"));
            } else {
                final Act act = this.browser.getAct(this.browser.getMarked());
                final Entity schedule = this.browser.getSelectedSchedule();
                final Date startTime = this.browser.getSelectedTime();
                if (act == null) {
                    InformationDialog.show((String)Messages.get((String)"workflow.scheduling.appointment.paste.title"), (String)Messages.get((String)"workflow.scheduling.appointment.paste.noexist"));
                    this.onRefresh((Act)null);
                    this.browser.clearMarked();
                } else if (this.browser.isCut() && act.isA("act.customerAppointment") && !"PENDING".equals(act.getStatus()) && !"CONFIRMED".equals(act.getStatus())) {
                    InformationDialog.show((String)Messages.get((String)"workflow.scheduling.appointment.paste.title"), (String)Messages.get((String)"workflow.scheduling.appointment.cut.pending"));
                    this.onRefresh(act);
                    this.browser.clearMarked();
                } else if (schedule == null || startTime == null) {
                    InformationDialog.show((String)Messages.get((String)"workflow.scheduling.appointment.paste.title"), (String)Messages.get((String)"workflow.scheduling.appointment.paste.noslot"));
                } else {
                    final ScheduleEventSeriesState state = new ScheduleEventSeriesState(act, (IArchetypeService)ServiceHelper.getArchetypeService());
                    HelpContext help = this.getHelpContext();
                    if (this.browser.isCut()) {
                        if (state.hasSeries() && state.canEditFuture()) {
                            final MoveSeriesDialog dialog = new MoveSeriesDialog(state, help.subtopic("moveseries"));
                            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                                public void onOK() {
                                    if (dialog.single()) {
                                        AppointmentCRUDWindow.this.cut(act, schedule, startTime, null);
                                    } else if (dialog.future()) {
                                        AppointmentCRUDWindow.this.cut(act, schedule, startTime, state);
                                    } else if (dialog.all()) {
                                        AppointmentCRUDWindow.this.cut(state.getFirst(), schedule, startTime, state);
                                    }
                                }
                            });
                            dialog.show();
                        } else {
                            this.cut(act, schedule, startTime, null);
                        }
                    } else if (state.hasSeries() && state.canEditFuture()) {
                        final CopySeriesDialog dialog = new CopySeriesDialog(state, help.subtopic("copyseries"));
                        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                            public void onOK() {
                                if (dialog.single()) {
                                    AppointmentCRUDWindow.this.copy(act, schedule, startTime, null, 0);
                                } else if (dialog.future()) {
                                    AppointmentCRUDWindow.this.copy(act, schedule, startTime, state, state.getIndex());
                                } else if (dialog.all()) {
                                    AppointmentCRUDWindow.this.copy(state.getFirst(), schedule, startTime, state, 0);
                                }
                            }
                        });
                        dialog.show();
                    } else {
                        this.copy(act, schedule, startTime, null, 0);
                    }
                }
            }
        }
    }

    protected void delete(final Act object) {
        final ScheduleEventSeriesState state = new ScheduleEventSeriesState(object, (IArchetypeService)ServiceHelper.getArchetypeService());
        if (state.hasSeries() && state.canEditFuture()) {
            final DeleteSeriesDialog dialog = new DeleteSeriesDialog(state, this.getHelpContext().subtopic("deleteseries"));
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    boolean deleted = false;
                    if (dialog.single()) {
                        deleted = state.delete();
                    } else if (dialog.future()) {
                        deleted = state.deleteFuture();
                    } else if (dialog.all()) {
                        deleted = state.deleteSeries();
                    }
                    if (deleted) {
                        AppointmentCRUDWindow.this.onDeleted((IMObject)object);
                    }
                }
            });
            dialog.show();
        } else {
            super.delete((IMObject)object);
        }
    }

    @Override
    protected AppointmentActions getActions() {
        return (AppointmentActions)super.getActions();
    }

    protected void edit(final Act object, final List<Selection> path) {
        this.oldStatus = object.getStatus();
        final ScheduleEventSeriesState state = new ScheduleEventSeriesState(object, (IArchetypeService)ServiceHelper.getArchetypeService());
        if (state.hasSeries()) {
            if (state.canEditFuture()) {
                final EditSeriesDialog dialog = new EditSeriesDialog(state, this.getHelpContext().subtopic("editseries"));
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        if (dialog.single()) {
                            AppointmentCRUDWindow.this.edit(object, path, false);
                        } else if (dialog.future()) {
                            AppointmentCRUDWindow.this.edit(object, path, true);
                        } else if (dialog.all()) {
                            AppointmentCRUDWindow.this.edit(state.getFirst(), path, true);
                        }
                    }
                });
                dialog.show();
            } else {
                this.edit(object, path, false);
            }
        } else {
            this.edit(object, path, true);
        }
    }

    protected void edit(Act object, List<Selection> path, boolean editSeries) {
        try {
            HelpContext edit = this.createEditTopic((IMObject)object);
            LayoutContext context = this.createLayoutContext(edit);
            AbstractCalendarEventEditor editor = this.isAppointment(object) ? new AppointmentEditor(object, null, editSeries, context) : new CalendarBlockEditor(object, null, editSeries, context);
            editor.getComponent();
            this.edit((IMObjectEditor)editor, (List)path);
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show((Throwable)exception);
        }
    }

    protected AbstractCalendarEventEditDialog edit(IMObjectEditor editor, List<Selection> path) {
        Date startTime = this.browser.getSelectedTime();
        if (startTime != null && editor.getObject().isNew() && editor instanceof AbstractCalendarEventEditor) {
            ((AbstractCalendarEventEditor)editor).setStartTime(startTime);
        }
        return (AbstractCalendarEventEditDialog)super.edit(editor, path);
    }

    protected void onSaved(Act object, boolean isNew) {
        super.onSaved((IMObject)object, isNew);
        String newStatus = object.getStatus();
        if (this.isAppointment(object)) {
            PatientContext context;
            if (!this.isCancelledOrNoShow(this.oldStatus) && this.isCancelledOrNoShow(newStatus)) {
                PatientContext context2 = this.getPatientContext(object);
                if (context2 != null) {
                    PatientInformationService service = (PatientInformationService)ServiceHelper.getBean(PatientInformationService.class);
                    service.admissionCancelled(context2);
                }
            } else if (!this.isAdmitted(this.oldStatus) && this.isAdmitted(newStatus)) {
                PatientContext context3 = this.getPatientContext(object);
                if (context3 != null) {
                    PatientInformationService service = (PatientInformationService)ServiceHelper.getBean(PatientInformationService.class);
                    service.admitted(context3);
                }
            } else if (this.isAdmitted(this.oldStatus) && !this.isAdmitted(newStatus) && (context = this.getPatientContext(object)) != null) {
                PatientInformationService service = (PatientInformationService)ServiceHelper.getBean(PatientInformationService.class);
                service.discharged(context);
            }
        }
    }

    @Override
    protected void layoutButtons(ButtonSet buttons) {
        super.layoutButtons(buttons);
        buttons.add(CONFIRM_ID, this.action("act.customerAppointment", this::onConfirm, "workflow.scheduling.appointment.confirm.title"));
        buttons.add(CHECKIN_ID, this::onCheckIn);
        buttons.add(this.createConsultButton());
        buttons.add(this.createCheckOutButton());
        buttons.add(TRANSFER_ID, this::onTransfer);
        buttons.add(this.createOverTheCounterButton());
        buttons.add(this.createFlowSheetButton());
        buttons.addKeyListener(8259, this::onCopy);
        buttons.addKeyListener(8280, this::cut);
        buttons.addKeyListener(8278, this::paste);
        if (SMSHelper.isSMSEnabled((Party)this.getContext().getPractice())) {
            buttons.add(REMIND_ID, this::onSMS);
        }
        buttons.add(BLOCK_ID, this::onBlock);
    }

    @Override
    protected void enableButtons(ButtonSet buttons, boolean enable) {
        enable = this.browser.isAppointmentsSelected() && enable;
        super.enableButtons(buttons, enable);
        boolean confirmEnabled = false;
        boolean checkInEnabled = false;
        boolean checkoutConsultEnabled = false;
        boolean transferEnabled = false;
        boolean smsEnabled = false;
        boolean printEnabled = false;
        if (enable) {
            Act act = (Act)this.getObject();
            AppointmentActions actions = this.getActions();
            confirmEnabled = actions.canConfirm(act);
            if (actions.canCheckIn(act)) {
                checkInEnabled = true;
            } else if (actions.canCheckoutOrConsult(act)) {
                checkoutConsultEnabled = true;
            }
            transferEnabled = actions.canTransfer(act);
            smsEnabled = actions.canSMS(act);
            printEnabled = this.getActions().isAppointment(act);
        }
        boolean canCreateAppointment = this.canCreateAppointment();
        buttons.setEnabled("button.new", canCreateAppointment);
        this.enablePrintPreview(buttons, printEnabled);
        buttons.setEnabled(CONFIRM_ID, confirmEnabled);
        buttons.setEnabled(CHECKIN_ID, checkInEnabled);
        buttons.setEnabled("button.consult", checkoutConsultEnabled);
        buttons.setEnabled("button.checkout", checkoutConsultEnabled);
        buttons.setEnabled(TRANSFER_ID, transferEnabled);
        buttons.setEnabled("button.OTC", this.browser.isAppointmentsSelected());
        buttons.setEnabled(REMIND_ID, smsEnabled);
        buttons.setEnabled(BLOCK_ID, canCreateAppointment);
    }

    protected LayoutContext createLayoutContext(HelpContext help) {
        LocalClinicianContext local = new LocalClinicianContext(this.getContext());
        return new DefaultLayoutContext(true, (Context)local, help);
    }

    private boolean canCreateAppointment() {
        return this.browser.isAppointmentsSelected() && this.browser.getSelectedSchedule() != null && this.browser.getSelectedTime() != null;
    }

    private void onConfirm(Act appointment) {
        if ("PENDING".equals(appointment.getStatus())) {
            IMObjectBean bean = this.getBean((IMObject)appointment);
            bean.setValue("status", (Object)"CONFIRMED");
            bean.setValue("confirmedTime", (Object)new Date());
            SaveHelper.save((IMObject)appointment);
        }
        this.onRefresh(appointment);
    }

    private void onCheckIn() {
        Act act = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (act != null && this.getActions().canCheckIn(act)) {
            WorkflowFactory factory = (WorkflowFactory)ServiceHelper.getBean(WorkflowFactory.class);
            Workflow workflow = factory.createCheckInWorkflow(act, this.getContext(), this.getHelpContext());
            workflow.addTaskListener((TaskListener)new DefaultTaskListener(){

                public void taskEvent(TaskEvent event) {
                    AppointmentCRUDWindow.this.onRefresh((Act)AppointmentCRUDWindow.this.getObject());
                }
            });
            workflow.start();
        } else {
            this.onRefresh((Act)this.getObject());
        }
    }

    private void onTransfer() {
        Act act = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (act != null && this.getActions().canTransfer(act)) {
            TransferWorkflow workflow = new TransferWorkflow(act, this.getContext(), this.getHelpContext());
            workflow.start();
        } else {
            this.onRefresh((Act)this.getObject());
        }
    }

    private void onCopy() {
        if (this.browser.isAppointmentsSelected()) {
            this.browser.clearMarked();
            PropertySet selected = this.browser.getSelected();
            Act appointment = this.browser.getAct(selected);
            if (appointment != null) {
                this.browser.setMarked(selected, false);
            } else {
                InformationDialog.show((String)Messages.get((String)"workflow.scheduling.appointment.copy.title"), (String)Messages.get((String)"workflow.scheduling.appointment.copy.select"));
            }
        }
    }

    private void onSMS() {
        Act object = (Act)IMObjectHelper.reload((IMObject)this.getObject());
        if (object != null) {
            IMObjectBean bean = this.getBean((IMObject)object);
            Party customer = (Party)bean.getTarget("customer", Party.class);
            Party patient = (Party)bean.getTarget("patient", Party.class);
            Party location = this.getLocation(bean);
            Context context = this.getContext();
            List contacts = ContactHelper.getSMSContacts((Party)customer);
            if (!contacts.isEmpty() && location != null) {
                final AppointmentSMSDialog dialog = new AppointmentSMSDialog(object, contacts, customer, patient, location, context, this.getHelpContext().subtopic("sms"));
                dialog.show();
                dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                    public void onOK() {
                        AppointmentCRUDWindow.this.onSaved(dialog.getAppointment(), false);
                    }
                });
            } else if (contacts.isEmpty()) {
                InformationDialog.show((String)Messages.get((String)"sms.appointment.nocontact"));
            } else {
                InformationDialog.show((String)Messages.get((String)"sms.appointment.nolocation"));
            }
        } else {
            this.onRefresh((Act)this.getObject());
        }
    }

    private void onBlock() {
        if (this.canCreateAppointment()) {
            this.onCreate(BLOCK);
        }
    }

    private Party getLocation(IMObjectBean bean) {
        Entity schedule = (Entity)bean.getTarget("schedule", Entity.class);
        if (schedule != null) {
            IMObjectBean scheduleBean = this.getBean((IMObject)schedule);
            return (Party)scheduleBean.getTarget("location", Party.class);
        }
        return null;
    }

    private void cut(Act act, Entity schedule, Date startTime, ScheduleEventSeriesState series) {
        if (this.isAppointment(act) && DateRules.compareTo((Date)act.getActivityStartTime(), (Date)startTime) != 0) {
            IMObjectBean bean = this.getBean((IMObject)act);
            bean.setValue("reminderSent", null);
            bean.setValue("reminderError", null);
            bean.setValue("status", (Object)"PENDING");
        }
        int duration = this.getDuration(act.getActivityStartTime(), act.getActivityEndTime());
        this.paste(act, schedule, startTime, duration, series, false, null, null);
        this.browser.clearMarked();
    }

    private void copy(Act act, Entity schedule, Date startTime, ScheduleEventSeriesState series, int index) {
        int duration = this.getDuration(act.getActivityStartTime(), act.getActivityEndTime());
        act = this.rules.copy(act);
        IMObjectBean bean = this.getBean((IMObject)act);
        if (this.isAppointment(act)) {
            bean.setValue("status", (Object)"PENDING");
            bean.setValue("arrivalTime", null);
            bean.setValue("confirmedTime", null);
            bean.setValue("reminderSent", null);
            bean.setValue("reminderError", null);
        }
        RepeatExpression expression = series != null ? series.getExpression() : null;
        RepeatCondition condition = series != null ? series.getCondition(index) : null;
        this.paste(act, schedule, startTime, duration, series, true, expression, condition);
    }

    private void paste(Act act, Entity schedule, Date startTime, int duration, ScheduleEventSeriesState series, boolean copy, RepeatExpression expression, RepeatCondition condition) {
        int newLength;
        HelpContext edit = this.createEditTopic((IMObject)act);
        LocalContext localContext = LocalContext.copy((Context)this.getContext());
        localContext.setCustomer(null);
        localContext.setPatient(null);
        localContext.setClinician(null);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)localContext, edit);
        AbstractCalendarEventEditor editor = this.createEditor(act, series, context);
        EditDialog dialog = this.edit((IMObjectEditor)editor, (List)null);
        editor.setSchedule(schedule);
        editor.setStartTime(startTime);
        startTime = editor.getStartTime();
        Date endTime = editor.getEndTime();
        if (endTime != null && (newLength = this.getDuration(editor.getStartTime(), endTime)) < duration) {
            editor.setEndTime(DateRules.getDate((Date)startTime, (int)duration, (DateUnits)DateUnits.MINUTES));
        }
        if (copy) {
            editor.setExpression(expression);
            editor.setCondition(condition);
        } else {
            editor.getSeries().setUpdateTimesOnly(true);
        }
        dialog.setAlwaysCheckOverlap(true);
        dialog.save(true);
        this.browser.setSelected(this.browser.getEvent(act));
    }

    private AbstractCalendarEventEditor createEditor(Act act, ScheduleEventSeriesState series, DefaultLayoutContext context) {
        AbstractCalendarEventEditor result = this.isAppointment(act) ? new AppointmentEditor(act, null, series != null, (LayoutContext)context) : new CalendarBlockEditor(act, null, series != null, (LayoutContext)context);
        return result;
    }

    private int getDuration(Date startTime, Date endTime) {
        return DateRules.minutesBetween((Date)startTime, (Date)endTime);
    }

    private PatientContext getPatientContext(Act appointment) {
        return PatientContextHelper.getAppointmentContext(appointment, this.getContext());
    }

    private boolean isAdmitted(String status) {
        return "CHECKED_IN".equals(status) || "ADMITTED".equals(status) || "IN_PROGRESS".equals(status) || "BILLED".equals(status);
    }

    private boolean isCancelledOrNoShow(String status) {
        return "CANCELLED".equals(status) || "NO_SHOW".equals(status);
    }

    private boolean isAppointment(Act object) {
        return this.getActions().isAppointment(object);
    }

    protected static class AppointmentActions
    extends ScheduleCRUDWindow.ScheduleActions {
        public static AppointmentActions INSTANCE = new AppointmentActions();

        protected AppointmentActions() {
        }

        public boolean isAppointment(Act act) {
            return act.isA("act.customerAppointment");
        }

        public boolean canConfirm(Act act) {
            return this.isAppointment(act) && "PENDING".equals(act.getStatus());
        }

        public boolean canCheckIn(Act act) {
            return this.isAppointment(act) && ("PENDING".equals(act.getStatus()) || "CONFIRMED".equals(act.getStatus())) && this.getBean((IMObject)act).getTargetRef("customer") != null;
        }

        @Override
        public boolean canCheckoutOrConsult(Act act) {
            String status = act.getStatus();
            return this.isAppointment(act) && ("CHECKED_IN".equals(status) || "IN_PROGRESS".equals(status) || "COMPLETED".equals(status) || "BILLED".equals(status));
        }

        public boolean canSMS(Act act) {
            Party customer;
            boolean result = false;
            IMObjectBean bean = this.getBean((IMObject)act);
            if (this.isAppointment(act) && "PENDING".equals(act.getStatus()) && DateRules.compareDateToToday((Date)act.getActivityStartTime()) >= 0 && SMSHelper.canSMS((Party)(customer = (Party)bean.getTarget("customer", Party.class)))) {
                result = true;
            }
            return result;
        }

        public boolean canTransfer(Act act) {
            String status = act.getStatus();
            return this.isAppointment(act) && ("CHECKED_IN".equals(status) || "IN_PROGRESS".equals(status) || "ADMITTED".equals(status) || "BILLED".equals(status) || "COMPLETED".equals(status));
        }
    }
}

