/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow.appointment;

import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.workflow.AppointmentRules;
import org.openvpms.archetype.rules.workflow.roster.RosterService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.system.common.util.PropertySet;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.workspace.workflow.appointment.AbstractScheduleEventGrid;
import org.openvpms.web.workspace.workflow.appointment.AppointmentGrid;
import org.openvpms.web.workspace.workflow.appointment.Slot;
import org.openvpms.web.workspace.workflow.scheduling.Schedule;
import org.openvpms.web.workspace.workflow.scheduling.ScheduleEventGrid;

public abstract class AbstractAppointmentGrid
extends AbstractScheduleEventGrid
implements AppointmentGrid {
    private final AppointmentRules rules;
    private final RosterService rosterService;
    private int startMins;
    private int endMins;
    private boolean showRoster;
    private int slotSize = 15;
    static final int DEFAULT_SLOT_SIZE = 15;
    static final int DEFAULT_START = 480;
    static final int DEFAULT_END = 1080;
    private static final int MAX_TIME = 1440;

    public AbstractAppointmentGrid(Entity scheduleView, Date date, int startMins, int endMins, AppointmentRules rules, RosterService rosterService) {
        super(scheduleView, date, rules);
        this.startMins = startMins;
        this.endMins = endMins;
        this.rules = rules;
        this.rosterService = rosterService;
    }

    @Override
    public int getStartMins() {
        return this.startMins;
    }

    @Override
    public int getEndMins() {
        return this.endMins;
    }

    @Override
    public int getSlots() {
        return this.getSlotTimes().size();
    }

    @Override
    public int getSlotSize() {
        return this.slotSize;
    }

    @Override
    public int getSlots(PropertySet event, Schedule schedule, int slot) {
        Date nextStartTime;
        int nextStartSlot;
        PropertySet next;
        Date startTime = this.getStartTime(slot);
        Date endTime = event.getDate("act.endTime");
        int endSlot = this.getSlot(endTime, true);
        int slots = endSlot - slot;
        if (slots > 1 && Schedule.isBlockingEvent(event) && (next = schedule.getEventAfter(event, startTime)) != null && (nextStartSlot = this.getSlot(nextStartTime = next.getDate("act.startTime"))) < endSlot) {
            slots = nextStartSlot - slot;
        }
        return slots;
    }

    @Override
    public Date getStartTime(int slot) {
        return Date.from(this.getSlot(slot).getStart().toInstant());
    }

    @Override
    public Date getEndTime(int slot) {
        return Date.from(this.getSlot(slot).getEnd().toInstant());
    }

    @Override
    public Date getStartTime(Schedule schedule, int slot) {
        return this.getStartTime(slot);
    }

    @Override
    public Date getEndTime(Schedule schedule, int slot) {
        return this.getEndTime(slot);
    }

    @Override
    public int getHour(int slot) {
        return this.getSlotTimes().get(slot).getStart().getHour();
    }

    @Override
    public ScheduleEventGrid.Availability getAvailability(Schedule schedule, int slot) {
        if (this.getEvent(schedule, slot) != null) {
            return ScheduleEventGrid.Availability.BUSY;
        }
        ZonedDateTime time = this.getSlot(slot).getStart();
        if (time.compareTo(this.getSlotTimeForMinutes(schedule.getStartMins())) >= 0 && time.compareTo(this.getSlotTimeForMinutes(schedule.getEndMins())) < 0) {
            return ScheduleEventGrid.Availability.FREE;
        }
        return ScheduleEventGrid.Availability.UNAVAILABLE;
    }

    @Override
    public int getUnavailableSlots(Schedule schedule, int slot) {
        int i;
        int slots = this.getSlots();
        for (i = slot; i < slots && this.getAvailability(schedule, i) == ScheduleEventGrid.Availability.UNAVAILABLE; ++i) {
        }
        return i - slot;
    }

    @Override
    public int getSlot(Date time) {
        return this.getSlot(this.toZonedDateTime(time));
    }

    public int getSlot(Date time, boolean roundUp) {
        return this.getSlot(this.toZonedDateTime(time), roundUp);
    }

    @Override
    public int getSlot(ZonedDateTime time) {
        return this.getSlot(time, false);
    }

    @Override
    public int getSlot(ZonedDateTime time, boolean roundUp) {
        Slot slot;
        Slot key;
        List<Slot> slots = this.getSlotTimes();
        int index = Collections.binarySearch(slots, key = new Slot(time, time), (o1, o2) -> {
            ZonedDateTime start1 = o1.getStart();
            ZonedDateTime end1 = o1.getEnd();
            ZonedDateTime start2 = o2.getStart();
            ZonedDateTime end2 = o2.getEnd();
            if (start1.equals(end1) ? start1.compareTo(start2) >= 0 && start1.compareTo(end2) < 0 : start2.equals(end2) && start2.compareTo(start1) >= 0 && start2.compareTo(end1) < 0) {
                return 0;
            }
            if (end1.compareTo(start2) <= 0) {
                return -1;
            }
            if (start1.compareTo(end2) >= 0) {
                return 1;
            }
            return 0;
        });
        if (index < 0) {
            return index == -1 ? index : slots.size();
        }
        if (roundUp && time.compareTo((slot = slots.get(index)).getStart()) > 0) {
            ++index;
        }
        return index;
    }

    @Override
    public boolean showRoster() {
        return this.showRoster;
    }

    @Override
    public void setShowRoster(boolean show) {
        this.showRoster = show;
    }

    public static int getSlotSize(Entity schedule, AppointmentRules rules) {
        int slotSize = rules.getSlotSize(schedule);
        if (slotSize <= 0) {
            slotSize = 15;
        }
        return slotSize;
    }

    protected void setStartMins(int startMins) {
        this.startMins = startMins;
    }

    protected void setEndMins(int endMins) {
        this.endMins = endMins;
    }

    protected void setSlotSize(int slotSize) {
        this.slotSize = slotSize;
    }

    protected int getSlotMinutes(Date time, boolean roundUp) {
        return this.rules.getSlotMinutes(time, this.slotSize, roundUp);
    }

    protected Schedule createSchedule(Entity schedule) {
        IMObjectBean bean = IMObjectHelper.getBean((IMObject)schedule);
        Date start = bean.getDate("startTime");
        int slotSize = AbstractAppointmentGrid.getSlotSize(schedule, this.rules);
        int startMins = start != null ? this.getGridMinutes(start) : 480;
        Date end = bean.getDate("endTime");
        int endMins = end != null ? this.getGridMinutes(end) : 1080;
        if (endMins < startMins) {
            endMins = startMins;
        }
        List areas = this.rosterService.getAreas(schedule.getObjectReference());
        return new Schedule(schedule, null, startMins, endMins, slotSize, areas, this.rules);
    }

    ZonedDateTime getSlotTimeForMinutes(int startMins) {
        ZonedDateTime date = this.getStartZonedDateTime();
        return this.getTimePlusMinutes(date, startMins);
    }

    private Slot getSlot(int slot) {
        List<Slot> slots = this.getSlotTimes();
        if (slot >= slots.size()) {
            throw new IllegalArgumentException("Argument 'slot'=" + slot + " exceeds slots: " + slots.size());
        }
        return slots.get(slot);
    }

    private ZonedDateTime getTimePlusMinutes(ZonedDateTime start, int minutes) {
        return minutes < 1440 ? start.withHour(minutes / 60).withMinute(minutes % 60) : start.plusDays(1L);
    }

    private int getGridMinutes(Date time) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(time);
        int day = calendar.get(5) - 1;
        int hour = calendar.get(11);
        int mins = calendar.get(12);
        int result = day * 24 * 60 + hour * 60 + mins;
        if (result < 0 || result > 1440) {
            result = 480;
        }
        return result;
    }
}

