/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.workflow;

import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.workflow.WorkflowException;
import org.openvpms.web.workspace.workflow.i18n.WorkflowMessages;

public class GetInvoiceTask
extends SynchronousTask {
    private final CustomerAccountRules rules = (CustomerAccountRules)ServiceHelper.getBean(CustomerAccountRules.class);

    public void execute(TaskContext context) {
        FinancialAct invoice = this.getInvoice(context);
        if (invoice != null) {
            context.addObject((IMObject)invoice);
        }
    }

    protected FinancialAct getInvoice(TaskContext context) {
        Party customer = context.getCustomer();
        if (customer == null) {
            throw new WorkflowException(WorkflowMessages.contextHasNoCustomer());
        }
        return this.rules.getInvoice(customer);
    }
}

