/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.user;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.ImageReference;
import nextapp.echo2.app.Label;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.help.HelpTopics;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ConfirmationDialogBuilder;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.image.ThumbnailImageReference;
import org.openvpms.web.echo.util.StyleSheetHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.security.login.MfaService;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TOTPConfigurationDialog
extends ModalDialog {
    private final User user;
    private final MfaService service;
    private final Column container = ColumnFactory.create((String)"WideCellSpacing");
    private static final String NEW_TOTP = "button.newTOTP";
    private static final String DISABLE_TOTP = "button.disableTOTP";
    private static final String[] BUTTONS = new String[]{"button.newTOTP", "button.disableTOTP", "close"};
    private static final Logger log = LoggerFactory.getLogger(TOTPConfigurationDialog.class);

    public TOTPConfigurationDialog(User user) {
        super(Messages.get((String)"login.mfa.totpconfig.title"), BUTTONS, null);
        this.user = user;
        this.service = (MfaService)ServiceHelper.getBean(MfaService.class);
        this.container.setFont(StyleSheetHelper.getDefaultFont());
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{this.container}));
        this.resize("TOTPConfigurationDialog.size");
        this.display();
    }

    protected void onButton(String button) {
        if (NEW_TOTP.equals(button)) {
            this.onNewTOTP();
        } else if (DISABLE_TOTP.equals(button)) {
            this.onDisableTOTP();
        } else {
            super.onButton(button);
        }
    }

    private void display() {
        boolean hasTOTP = this.service.hasTOTP(this.user);
        this.container.removeAll();
        if (hasTOTP) {
            String url = this.service.getQRCodeURL(this.user);
            String baseURL = ((HelpTopics)ServiceHelper.getBean(HelpTopics.class)).getBaseURL();
            ImageReference qrCode = this.generateQRCode(url);
            this.container.add((Component)LabelFactory.create((String)"login.mfa.totpconfig.message", (boolean)true, (boolean)true));
            this.container.add((Component)LabelFactory.html((String)Messages.format((String)"login.mfa.totpconfig.apps", (Object[])new Object[]{baseURL}), (boolean)true));
            this.container.add((Component)new Label(qrCode));
        } else {
            this.container.add((Component)LabelFactory.create((String)"login.mfa.totpconfig.message", (boolean)true, (boolean)true));
            this.container.add((Component)LabelFactory.create((String)"login.mfa.totpconfig.new", (boolean)true, (boolean)true));
        }
        this.getButtons().setEnabled(DISABLE_TOTP, hasTOTP);
    }

    private void onNewTOTP() {
        if (this.service.hasTOTP(this.user)) {
            ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"login.mfa.totpconfig.title"))).message(Messages.get((String)"login.mfa.totpconfig.replace"))).yesNo()).yes(this::createTOTP)).show();
        } else {
            this.createTOTP();
        }
    }

    private void createTOTP() {
        this.service.configureTOTP(this.user);
        this.display();
    }

    private void onDisableTOTP() {
        ((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)((ConfirmationDialogBuilder)ConfirmationDialog.newDialog().title(Messages.get((String)"login.mfa.totpconfig.title"))).message(Messages.get((String)"login.mfa.totpconfig.disable"))).yesNo()).yes(this::disableTOTP)).show();
    }

    private void disableTOTP() {
        this.service.removeTOTP(this.user);
        this.onClose();
    }

    private ImageReference generateQRCode(String url) {
        ThumbnailImageReference result = null;
        try {
            QRCodeWriter writer = new QRCodeWriter();
            BitMatrix bitMatrix = writer.encode(url, BarcodeFormat.QR_CODE, 200, 200);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)bos);
            result = new ThumbnailImageReference(bos.toByteArray(), "application/png");
        }
        catch (Exception exception) {
            log.error("Failed to generate QR code: {}", (Object)exception.getMessage(), (Object)exception);
        }
        return result;
    }
}

