/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.SelectField;
import nextapp.echo2.app.list.ListCellRenderer;
import nextapp.echo2.app.list.ListModel;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.list.IMObjectListCellRenderer;
import org.openvpms.web.component.im.list.IMObjectListModel;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.factory.SelectFieldFactory;
import org.openvpms.web.echo.focus.FocusGroup;

public class StockLocationSupplierSelector {
    private final List<IMObject> stockLocations = this.query("party.organisationStockLocation");
    private final List<IMObject> suppliers;
    private final SelectField stockLocation;
    private final SelectField supplier;
    private final Component component;
    private final FocusGroup group;

    public StockLocationSupplierSelector(Context context) {
        this.stockLocation = SelectFieldFactory.create((ListModel)new IMObjectListModel(this.stockLocations, true, false), (Object)context.getStockLocation());
        this.stockLocation.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
        this.suppliers = this.query("party.supplierorganisation", "party.supplierperson");
        this.supplier = SelectFieldFactory.create((ListModel)new IMObjectListModel(this.suppliers, true, false));
        this.supplier.setCellRenderer((ListCellRenderer)IMObjectListCellRenderer.NAME);
        Grid grid = GridFactory.create((int)2);
        grid.add((Component)LabelFactory.create((String)"product.stockLocation"));
        grid.add((Component)this.stockLocation);
        grid.add((Component)LabelFactory.create((String)"supplier.type"));
        grid.add((Component)this.supplier);
        this.component = ColumnFactory.create((String)"Inset", (Component[])new Component[]{grid});
        this.group = new FocusGroup("StockLocationSupplierSelector");
        this.group.add(0, (Component)this.stockLocation);
        this.group.add(1, (Component)this.supplier);
        this.group.setFocus();
    }

    public Component getComponent() {
        return this.component;
    }

    public List<IMObject> getStockLocations() {
        return this.stockLocations;
    }

    public List<IMObject> getSuppliers() {
        return this.suppliers;
    }

    public Party getStockLocation() {
        return (Party)this.stockLocation.getSelectedItem();
    }

    public Party getSupplier() {
        return (Party)this.supplier.getSelectedItem();
    }

    public FocusGroup getFocusGroup() {
        return this.group;
    }

    private List<IMObject> query(String ... archetypes) {
        ArchetypeQuery query = new ArchetypeQuery(archetypes, false, true).add((IConstraint)Constraints.sort((String)"name")).add((IConstraint)Constraints.sort((String)"id")).setMaxResults(-1);
        return QueryHelper.query((ArchetypeQuery)query);
    }
}

