/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.order;

import java.util.HashSet;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.edit.AlertListener;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.table.IMTableModel;
import org.openvpms.web.component.im.view.IMObjectComponentFactory;
import org.openvpms.web.component.im.view.TableComponentFactory;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.supplier.order.OrderEditContext;
import org.openvpms.web.workspace.supplier.order.OrderItemEditor;
import org.openvpms.web.workspace.supplier.order.OrderItemTableModel;

public class OrderItemCollectionEditor
extends ActRelationshipCollectionEditor {
    private final OrderEditContext editContext = new OrderEditContext();
    private final Reference stockLocation;
    private String alertId;

    public OrderItemCollectionEditor(CollectionProperty property, Act act, LayoutContext context) {
        super(property, act, context);
        IMObjectBean bean = this.getBean((IMObject)act);
        this.stockLocation = bean.getTargetRef("stockLocation");
    }

    public IMObjectEditor createEditor(IMObject object, LayoutContext context) {
        OrderItemEditor editor = new OrderItemEditor((FinancialAct)object, (Act)this.getObject(), this.editContext, context);
        editor.setProductListener(this.getProductListener());
        return editor;
    }

    public void setAlertListener(AlertListener listener) {
        super.setAlertListener(listener);
        if (listener != null) {
            this.checkDuplicateProducts();
        }
    }

    public void remove(IMObject object) {
        super.remove(object);
        this.checkDuplicateProducts();
    }

    protected boolean addCurrentEdits(Validator validator) {
        boolean valid = super.addCurrentEdits(validator);
        if (valid) {
            this.checkDuplicateProducts();
        }
        return valid;
    }

    protected IMTableModel<IMObject> createTableModel(LayoutContext context) {
        Object model;
        if (this.stockLocation != null) {
            context = new DefaultLayoutContext(context);
            context.setComponentFactory((IMObjectComponentFactory)new TableComponentFactory(context));
            model = new OrderItemTableModel(this.stockLocation, this.editContext.getStock(), context);
        } else {
            model = super.createTableModel(context);
        }
        return model;
    }

    private void checkDuplicateProducts() {
        AlertListener listener = this.getAlertListener();
        if (listener != null) {
            if (this.alertId != null) {
                listener.cancel(this.alertId);
                this.alertId = null;
            }
            HashSet<Reference> products = new HashSet<Reference>();
            for (Act act : this.getCurrentActs()) {
                IMObjectBean bean = this.getBean((IMObject)act);
                Reference productRef = bean.getTargetRef("product");
                if (productRef != null && products.contains(productRef)) {
                    Product product = (Product)this.getObject(productRef);
                    if (product == null) continue;
                    this.alertId = listener.onAlert(Messages.format((String)"supplier.order.duplicate", (Object[])new Object[]{product.getName()}));
                    break;
                }
                products.add(productRef);
            }
        }
    }
}

