/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Row;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.ActResultSet;
import org.openvpms.web.component.im.query.DateRange;
import org.openvpms.web.component.im.query.ParticipantConstraint;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.RowFactory;
import org.openvpms.web.workspace.supplier.SupplierActQuery;

public class PostedOrderQuery
extends SupplierActQuery<FinancialAct> {
    private final boolean includeDateRange;
    private static final String[] ACTS = new String[]{"act.supplierOrder"};

    public PostedOrderQuery(boolean includeDateRange, LayoutContext context) {
        super(ACTS, null, FinancialAct.class, context);
        this.setStatuses(new String[]{"POSTED", "ACCEPTED"});
        this.includeDateRange = includeDateRange;
    }

    public ResultSet<FinancialAct> query(SortConstraint[] sort) {
        if (this.canQuery()) {
            return super.query(sort);
        }
        return null;
    }

    public Extent getHeight() {
        return this.includeDateRange ? this.getHeight(2) : this.getHeight(1);
    }

    protected void doLayout(Component container) {
        if (this.includeDateRange) {
            Row row1 = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
            Row row2 = RowFactory.create((String)"CellSpacing", (Component[])new Component[0]);
            this.addSupplierSelector((Component)row1);
            this.addStockLocationSelector((Component)row1);
            this.addStatusSelector((Component)row1);
            this.addDateRange((Component)row2);
            container.add((Component)ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{row1, row2}));
            Date date = DateRules.getDate((Date)new Date(), (int)-1, (DateUnits)DateUnits.MONTHS);
            this.setFrom(date);
        } else {
            this.addSupplierSelector(container);
            this.addStockLocationSelector(container);
        }
    }

    @Override
    protected ActResultSet<FinancialAct> createResultSet(ParticipantConstraint[] participants, SortConstraint[] sort) {
        Date from = null;
        Date to = null;
        if (this.includeDateRange) {
            DateRange range = this.getDateRange();
            from = range.getFrom();
            to = range.getTo();
        }
        return new ActResultSet(this.getArchetypeConstraint(), participants, from, to, this.getStatuses(), false, this.getConstraints(), this.getMaxResults(), sort);
    }

    protected void onQuery() {
        if (this.canQuery()) {
            super.onQuery();
        }
    }

    protected DateRange createDateRange() {
        return new DateRange(false);
    }

    private boolean canQuery() {
        return this.getSupplier() != null && this.getStockLocation() != null;
    }
}

