/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.delivery;

import org.openvpms.archetype.rules.supplier.OrderRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.im.edit.IMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.act.ActRelationshipCollectionEditor;
import org.openvpms.web.component.im.edit.act.FinancialActEditor;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.workspace.supplier.SupplierHelper;
import org.openvpms.web.workspace.supplier.delivery.DeliveryItemEditor;
import org.openvpms.web.workspace.supplier.delivery.DeliveryLayoutStrategy;

public class DeliveryEditor
extends FinancialActEditor {
    private final OrderRules rules;

    public DeliveryEditor(FinancialAct act, IMObject parent, LayoutContext context) {
        super(act, parent, context);
        this.rules = SupplierHelper.createOrderRules(context.getContext().getPractice());
        this.initialise();
    }

    public IMObjectEditor newInstance() {
        return new DeliveryEditor((FinancialAct)this.reload((IMObject)this.getObject()), this.getParent(), this.getLayoutContext());
    }

    public FinancialAct createItem(FinancialAct orderItem) {
        boolean delivery = this.getObject().isA("act.supplierDelivery");
        FinancialAct deliveryItem = delivery ? this.rules.createDeliveryItem(orderItem) : this.rules.createReturnItem(orderItem);
        ActRelationshipCollectionEditor items = this.getItems();
        items.add((IMObject)deliveryItem);
        DeliveryItemEditor itemEditor = (DeliveryItemEditor)this.getItems().getEditor((IMObject)deliveryItem);
        itemEditor.setOrderItem(orderItem);
        items.setModified((Act)deliveryItem, true);
        items.refresh();
        return deliveryItem;
    }

    public ActRelationshipCollectionEditor getItems() {
        return super.getItems();
    }

    protected void doSave() {
        this.saveChildren();
        this.saveObject();
    }

    protected IMObjectLayoutStrategy createLayoutStrategy() {
        return new DeliveryLayoutStrategy((IMObjectCollectionEditor)this.getItems());
    }
}

