/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.supplier.account;

import java.util.Date;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.rules.supplier.account.SupplierAccountRules;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.supplier.SupplierActCRUDWindow;

public class AccountCRUDWindow
extends SupplierActCRUDWindow<FinancialAct> {
    private static final String REVERSE_ID = "reverse";

    public AccountCRUDWindow(Archetypes<FinancialAct> archetypes, Context context, HelpContext help) {
        super(archetypes, ActActions.edit(), context, help);
    }

    protected void layoutButtons(ButtonSet buttons) {
        buttons.add(REVERSE_ID, this::onReverse);
        buttons.add(this.createPrintButton());
        buttons.add(this.createMailButton());
    }

    protected void enableButtons(ButtonSet buttons, boolean enable) {
        buttons.setEnabled(REVERSE_ID, enable);
        this.enablePrintPreview(buttons, enable);
    }

    protected void onReverse() {
        final FinancialAct act = (FinancialAct)IMObjectHelper.reload((IMObject)this.getObject());
        if (act != null && "POSTED".equals(act.getStatus())) {
            String name = this.getArchetypeDescriptor().getDisplayName();
            String title = Messages.format((String)"supplier.account.reverse.title", (Object[])new Object[]{name});
            String message = Messages.format((String)"supplier.account.reverse.message", (Object[])new Object[]{name});
            HelpContext help = this.getHelpContext().subtopic(REVERSE_ID);
            ConfirmationDialog dialog = new ConfirmationDialog(title, message, help);
            dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

                public void onOK() {
                    AccountCRUDWindow.this.reverse(act);
                }
            });
            dialog.show();
        } else {
            this.showStatusError((Act)act, "supplier.account.noreverse.title", "supplier.account.noreverse.message");
        }
    }

    private void reverse(FinancialAct act) {
        try {
            SupplierAccountRules rules = (SupplierAccountRules)ServiceHelper.getBean(SupplierAccountRules.class);
            rules.reverse(act, new Date());
            this.onRefresh((IMObject)act);
        }
        catch (OpenVPMSException exception) {
            String title = Messages.get((String)"supplier.account.reverse.failed");
            ErrorHelper.show((String)title, (Throwable)exception);
        }
    }
}

