/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.summary;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.archetype.rules.prefs.Preferences;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.alert.Alert;
import org.openvpms.web.component.alert.AlertManager;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class PartySummary {
    private final Context context;
    private final HelpContext help;
    private final Preferences preferences;

    public PartySummary(Context context, HelpContext help, Preferences preferences) {
        this.context = context;
        this.help = help;
        this.preferences = preferences;
    }

    public Component getSummary(Party party) {
        Component result = null;
        if (party != null) {
            List alerts = ((AlertManager)ServiceHelper.getBean(AlertManager.class)).getAlerts(party);
            result = this.createSummary(party, alerts);
        }
        return result;
    }

    protected Context getContext() {
        return this.context;
    }

    protected HelpContext getHelpContext() {
        return this.help;
    }

    protected Preferences getPreferences() {
        return this.preferences;
    }

    protected abstract Component createSummary(Party var1, List<Alert> var2);

    protected Label createLabel(String key, Object ... arguments) {
        String text = Messages.format((String)key, (Object[])arguments);
        Label label = LabelFactory.create();
        label.setText(text);
        return label;
    }
}

