/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement.reminder;

import java.util.Iterator;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.statement.reminder.AccountReminderQueryFactory;
import org.openvpms.web.workspace.reporting.statement.reminder.AccountReminderQueryIterator;

abstract class AccountReminderProgressBarProcessor
extends ProgressBarProcessor<ObjectSet> {
    public AccountReminderProgressBarProcessor(AccountReminderQueryFactory factory) {
        super(null);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        ArchetypeQuery query = factory.createQuery();
        query.setMaxResults(0);
        query.setCountResults(true);
        int size = service.get((IArchetypeQuery)query).getTotalResults();
        query.setCountResults(false);
        this.setItems((Iterator)((Object)new AccountReminderQueryIterator(query, 100, (IArchetypeService)service)), size);
    }

    protected void process(ObjectSet object) {
        Act reminder = (Act)object.get("reminder");
        FinancialAct charge = (FinancialAct)object.get("charge");
        this.process(reminder, charge);
        this.processCompleted(object);
    }

    protected abstract void process(Act var1, FinancialAct var2);

    protected void updated() {
        this.getIterator().updated();
    }

    protected AccountReminderQueryIterator getIterator() {
        return (AccountReminderQueryIterator)((Object)super.getIterator());
    }
}

