/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import org.openvpms.archetype.component.processor.Processor;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.resource.i18n.Messages;

class StatementProgressBarProcessor
extends ProgressBarProcessor<Party> {
    private final Processor<Party> processor;
    private final Label status;
    private boolean cancel;
    private final Component component;

    public StatementProgressBarProcessor(Processor<Party> processor, List<Party> customers) {
        this(processor, customers, customers.size());
    }

    public StatementProgressBarProcessor(Processor<Party> processor, Iterable<Party> customers, int size) {
        super(customers, size, null);
        this.processor = processor;
        this.status = LabelFactory.create();
        this.component = ColumnFactory.create((String)"CellSpacing", (Component[])new Component[]{this.getProgressBar(), this.status});
    }

    public Component getComponent() {
        return this.component;
    }

    public void processCompleted(Party customer) {
        this.status.setText(null);
        super.processCompleted((Object)customer);
    }

    public void processFailed(Party object, String message, Throwable cause) {
        super.processFailed((Object)object, message, cause);
    }

    public void setStatus(String status) {
        this.status.setText(status);
    }

    public boolean isSuspended() {
        return super.isSuspended() || this.cancel;
    }

    public void setCancel(boolean cancel) {
        this.cancel = cancel;
    }

    protected void process(Party customer) {
        String message = Messages.format((String)"reporting.statements.processing", (Object[])new Object[]{customer.getName()});
        this.setStatus(message);
        this.processor.process((Object)customer);
        if (!this.isSuspended()) {
            this.processCompleted(customer);
        }
    }
}

