/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import java.util.Date;
import org.openvpms.archetype.component.processor.Processor;
import org.openvpms.archetype.rules.finance.statement.StatementProcessorException;
import org.openvpms.archetype.rules.finance.statement.StatementService;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IterableIMObjectQuery;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.statement.AbstractStatementGenerator;
import org.openvpms.web.workspace.reporting.statement.StatementProgressBarProcessor;

class EndOfPeriodGenerator
extends AbstractStatementGenerator {
    private final StatementProgressBarProcessor progressBarProcessor;

    public EndOfPeriodGenerator(Date date, boolean postCompletedCharges, Context context, HelpContext help) {
        super(Messages.get((String)"reporting.statements.eop.title"), Messages.get((String)"reporting.statements.eop.cancel.title"), Messages.get((String)"reporting.statements.eop.cancel.message"), Messages.get((String)"reporting.statements.eop.retry.title"), help);
        Party practice = context.getPractice();
        if (practice == null) {
            throw new StatementProcessorException(StatementProcessorException.ErrorCode.InvalidConfiguration, new Object[]{"Context has no practice"});
        }
        StatementService statementService = (StatementService)ServiceHelper.getBean(StatementService.class);
        ArchetypeQuery query = new ArchetypeQuery("party.customerperson", false, false);
        int size = this.countCustomers(query);
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.setMaxResults(1000);
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        IterableIMObjectQuery customers = new IterableIMObjectQuery((IArchetypeService)service, (IArchetypeQuery)query);
        Processor processor = object -> statementService.endPeriod(object, date, postCompletedCharges);
        this.progressBarProcessor = new StatementProgressBarProcessor((Processor<Party>)processor, (Iterable<Party>)customers, size);
    }

    @Override
    protected StatementProgressBarProcessor getProcessor() {
        return this.progressBarProcessor;
    }

    private int countCustomers(ArchetypeQuery query) {
        query.setMaxResults(0);
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        query.setCountResults(true);
        int size = service.get((IArchetypeQuery)query).getTotalResults();
        query.setCountResults(false);
        return size;
    }
}

