/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.statement;

import java.math.BigDecimal;
import java.util.Date;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.table.DefaultTableColumnModel;
import nextapp.echo2.app.table.TableColumn;
import nextapp.echo2.app.table.TableColumnModel;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.table.AbstractIMTableModel;
import org.openvpms.web.component.im.view.IMObjectReferenceViewer;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.table.TableHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;
import org.openvpms.web.resource.i18n.format.NumberFormatter;

public class CustomerBalanceSummaryTableModel
extends AbstractIMTableModel<ObjectSet> {
    private final Context context;
    private static final int CUSTOMER_INDEX = 0;
    private static final int BALANCE_INDEX = 1;
    private static final int OVERDUE_BALANCE_INDEX = 2;
    private static final int CREDIT_BALANCE_INDEX = 3;
    private static final int UNBILLED_AMOUNT_INDEX = 4;
    private static final int LAST_PAYMENT_DATE_INDEX = 5;
    private static final int LAST_PAYMENT_AMOUNT_INDEX = 6;
    private static final int LAST_INVOICE_DATE_INDEX = 7;
    private String[][] columns = new String[][]{{"customer.objectReference", Messages.get((String)"customerbalancetablemodel.customer")}, {"balance", Messages.get((String)"customerbalancetablemodel.balance")}, {"overdueBalance", Messages.get((String)"customerbalancetablemodel.overdueBalance")}, {"creditBalance", Messages.get((String)"customerbalancetablemodel.creditBalance")}, {"unbilledAmount", Messages.get((String)"customerbalancetablemodel.unbilledAmount")}, {"lastPaymentDate", Messages.get((String)"customerbalancetablemodel.lastPaymentDate")}, {"lastPaymentAmount", Messages.get((String)"customerbalancetablemodel.lastPaymentAmount")}, {"lastInvoiceDate", Messages.get((String)"customerbalancetablemodel.lastInvoiceDate")}};

    public CustomerBalanceSummaryTableModel(Context context) {
        this.context = context;
        DefaultTableColumnModel model = new DefaultTableColumnModel();
        for (int i = 0; i < this.columns.length; ++i) {
            model.addColumn(new TableColumn(i));
        }
        this.setTableColumnModel((TableColumnModel)model);
    }

    public String getColumnName(int column) {
        return this.columns[column][1];
    }

    public SortConstraint[] getSortConstraints(int column, boolean ascending) {
        return null;
    }

    protected Object getValue(ObjectSet set, TableColumn column, int row) {
        Component result = null;
        int index = column.getModelIndex();
        Object value = set.get(this.columns[index][0]);
        switch (index) {
            case 0: {
                String name = set.getString("customer.name");
                result = this.getViewer((IMObjectReference)value, name);
                break;
            }
            case 1: {
                result = this.getAmount((BigDecimal)value);
                break;
            }
            case 2: {
                result = this.getAmount((BigDecimal)value);
                break;
            }
            case 3: {
                result = this.getAmount((BigDecimal)value);
                break;
            }
            case 4: {
                result = this.getAmount((BigDecimal)value);
                break;
            }
            case 5: {
                result = this.getDate((Date)value);
                break;
            }
            case 6: {
                result = this.getAmount((BigDecimal)value);
                break;
            }
            case 7: {
                result = this.getDate((Date)value);
            }
        }
        return result;
    }

    private Component getViewer(IMObjectReference party, String name) {
        IMObjectReferenceViewer viewer = new IMObjectReferenceViewer((Reference)party, name, true, this.context);
        return viewer.getComponent();
    }

    private Component getDate(Date date) {
        Label label = LabelFactory.create();
        if (date != null) {
            label.setText(DateFormatter.formatDate((Date)date, (boolean)false));
        }
        return label;
    }

    private Component getAmount(BigDecimal amount) {
        Label label = amount != null ? TableHelper.rightAlign((String)NumberFormatter.formatCurrency((Number)amount)) : LabelFactory.create();
        return label;
    }
}

