/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.report;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.apache.commons.io.FilenameUtils;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.component.model.document.Document;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.report.ParameterType;
import org.openvpms.report.Report;
import org.openvpms.report.ReportFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.doc.FileNameFormatter;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.im.report.ReportRunner;
import org.openvpms.web.component.print.AbstractPrinter;
import org.openvpms.web.workspace.reporting.report.SQLReportException;

public class SQLReportPrinter
extends AbstractPrinter {
    private final DocumentTemplate template;
    private final Report report;
    private final ReportRunner runner;
    private final FileNameFormatter formatter;
    private final DataSource dataSource;
    private final String connectionName;
    private Map<String, Object> parameters = Collections.emptyMap();
    private DocumentPrinter defaultPrinter;

    public SQLReportPrinter(DocumentTemplate template, Context context, ReportFactory factory, FileNameFormatter formatter, DataSource dataSource, PrinterContext printerContext) {
        super(printerContext, context);
        this.report = factory.createReport(template);
        this.runner = new ReportRunner(this.report);
        this.template = template;
        this.formatter = formatter;
        this.dataSource = dataSource;
        ParameterType connectionParam = this.getConnectionParameter();
        if (connectionParam == null) {
            throw new SQLReportException(SQLReportException.ErrorCode.NoQuery, new Object[0]);
        }
        this.connectionName = connectionParam.getName();
        DocumentPrinter defaultPrinter = this.getDefaultPrinter();
        boolean interactive = defaultPrinter == null || this.getInteractive(template, defaultPrinter);
        this.setInteractive(interactive);
    }

    public DocumentTemplate getTemplate() {
        return this.template;
    }

    public Set<ParameterType> getParameterTypes() {
        return this.report.getParameterTypes();
    }

    public void setParameters(Map<String, Object> parameters) {
        if (parameters == null) {
            parameters = Collections.emptyMap();
        }
        this.parameters = parameters;
    }

    public void print(DocumentPrinter printer) {
        block15: {
            if (printer.canUseJavaPrintServiceAPI()) {
                Map<String, Object> params = this.getParameters(false);
                try (Connection connection = this.dataSource.getConnection();){
                    params.put(this.connectionName, connection);
                    this.runner.run(() -> this.report.print(params, ReportContextFactory.create((Context)this.getContext()), this.getProperties(printer)));
                    break block15;
                }
                catch (SQLException exception) {
                    throw new SQLReportException(SQLReportException.ErrorCode.ConnectionError, exception);
                }
            }
            Document document = this.getDocument();
            this.print(document, printer);
        }
    }

    public DocumentPrinter getDefaultPrinter() {
        if (this.defaultPrinter == null) {
            this.defaultPrinter = this.getDefaultPrinter(this.template);
        }
        return this.defaultPrinter;
    }

    public Document getDocument() {
        return this.getDocument("application/pdf", true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document getDocument(String mimeType, boolean email) {
        Map<String, Object> params = this.getParameters(email);
        try (Connection connection = this.dataSource.getConnection();){
            params.put(this.connectionName, connection);
            Supplier<Document> generator = () -> {
                Map fields = ReportContextFactory.create((Context)this.getContext());
                return this.report.generate(params, fields, mimeType);
            };
            Document document = this.runner.run(generator);
            String extension = FilenameUtils.getExtension((String)document.getName());
            String fileName = this.getFileName();
            document.setName(fileName + "." + extension);
            Document document2 = document;
            return document2;
        }
        catch (SQLException exception) {
            throw new SQLReportException(SQLReportException.ErrorCode.ConnectionError, exception);
        }
    }

    public String getDisplayName() {
        return this.template.getName();
    }

    protected String getFileName() {
        return this.formatter.format(this.template.getName(), null, this.template);
    }

    private ParameterType getConnectionParameter() {
        for (ParameterType type : this.report.getParameterTypes()) {
            if (!Connection.class.equals((Object)type.getType())) continue;
            return type;
        }
        return null;
    }

    private Map<String, Object> getParameters(boolean email) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.parameters != null) {
            result.putAll(this.parameters);
        }
        result.put("IsEmail", email);
        return result;
    }
}

