/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.report;

import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.report.ParameterType;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.report.ReportContextFactory;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailDialog;
import org.openvpms.web.component.print.InteractiveExportPrinter;
import org.openvpms.web.component.print.PrintDialog;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.report.ParameterEvaluator;
import org.openvpms.web.workspace.reporting.report.SQLReportDialog;
import org.openvpms.web.workspace.reporting.report.SQLReportPrinter;

public class InteractiveSQLReportPrinter
extends InteractiveExportPrinter {
    private final Variables variables;

    public InteractiveSQLReportPrinter(SQLReportPrinter printer, Context context, MailContext mailContext, HelpContext help, Variables variables) {
        super((Printer)printer, context, mailContext, help);
        this.variables = variables;
    }

    protected PrintDialog createDialog() {
        final SQLReportPrinter printer = this.getPrinter();
        Set<ParameterType> parameterTypes = this.replaceVariables(printer.getParameterTypes());
        Party location = this.getContext().getLocation();
        return new SQLReportDialog(this.getTitle(), parameterTypes, this.variables, location, this.getHelpContext()){

            @Override
            protected void doPrint() {
                printer.setParameters(this.getValues());
            }

            @Override
            protected void doPreview() {
                printer.setParameters(this.getValues());
                InteractiveSQLReportPrinter.this.preview();
            }

            @Override
            protected void doMail() {
                printer.setParameters(this.getValues());
                InteractiveSQLReportPrinter.this.mail((PrintDialog)this);
            }

            @Override
            protected void doExport() {
                printer.setParameters(this.getValues());
                InteractiveSQLReportPrinter.this.export();
            }

            @Override
            protected void doExportMail() {
                printer.setParameters(this.getValues());
                InteractiveSQLReportPrinter.this.exportMail((PrintDialog)this);
            }
        };
    }

    protected SQLReportPrinter getPrinter() {
        return (SQLReportPrinter)super.getPrinter();
    }

    protected String getTitle() {
        return Messages.format((String)"reporting.run.title", (Object[])new Object[]{this.getDisplayName()});
    }

    protected void show(MailDialog dialog) {
        super.show(dialog);
        DocumentTemplate template = this.getPrinter().getTemplate();
        EmailTemplate emailTemplate = template.getEmailTemplate();
        if (emailTemplate != null) {
            dialog.getMailEditor().setContent(emailTemplate);
        }
    }

    private Set<ParameterType> replaceVariables(Set<ParameterType> parameterTypes) {
        ParameterEvaluator evaluator = new ParameterEvaluator((ArchetypeService)ServiceHelper.getArchetypeService(), ServiceHelper.getLookupService());
        Map variables = ReportContextFactory.create((Context)this.getContext());
        return evaluator.evaluate(parameterTypes, variables);
    }
}

