/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.List;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.component.im.sms.SMSHelper;
import org.openvpms.web.workspace.reporting.ReportingException;
import org.openvpms.web.workspace.reporting.reminder.GroupedReminders;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSEvaluator;

public class SMSReminders
extends GroupedReminders {
    private final ReminderSMSEvaluator evaluator;
    private Entity smsTemplate;
    private String text;

    public SMSReminders(ReminderType.GroupBy groupBy, boolean resend, ReminderSMSEvaluator evaluator) {
        super(groupBy, resend);
        this.evaluator = evaluator;
    }

    public String getPhoneNumber() {
        return SMSHelper.getPhone((Contact)this.getContact());
    }

    public void setSMSTemplate(Entity smsTemplate) {
        this.smsTemplate = smsTemplate;
    }

    public Entity getSMSTemplate() {
        return this.smsTemplate;
    }

    public String getText(Party practice) {
        String result;
        List<ReminderEvent> reminders = this.getReminders();
        Party customer = this.getCustomer();
        Party location = this.getLocation();
        try {
            if (reminders.size() == 1) {
                ReminderEvent event = reminders.get(0);
                Act reminder = event.getReminder();
                Party patient = (Party)event.get("patient");
                result = this.evaluator.evaluate(this.smsTemplate, reminder, customer, patient, location, practice);
            } else {
                ReminderEvent event = reminders.get(0);
                Party patient = event.getPatient();
                List<ObjectSet> sets = this.getObjectSets(reminders);
                result = this.evaluator.evaluate(this.smsTemplate, sets, customer, patient, location, practice);
            }
        }
        catch (Throwable exception) {
            throw new ReportingException(ReportingException.ErrorCode.SMSEvaluationFailed, exception, this.smsTemplate.getName());
        }
        this.text = result;
        return result;
    }

    public String getText() {
        return this.text;
    }
}

