/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.archetype.rules.party.SMSMatcher;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.im.sms.SMSHelper;
import org.openvpms.web.component.service.SimpleSMSService;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.ReportingException;
import org.openvpms.web.workspace.reporting.reminder.GroupedReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSEvaluator;
import org.openvpms.web.workspace.reporting.reminder.SMSReminders;

public class ReminderSMSProcessor
extends GroupedReminderProcessor<SMSReminders> {
    private final SimpleSMSService smsService;
    private final ReminderSMSEvaluator evaluator;
    private final boolean smsEnabled;

    public ReminderSMSProcessor(SimpleSMSService smsService, ReminderSMSEvaluator evaluator, ReminderTypes reminderTypes, Party practice, ReminderRules reminderRules, PatientRules patientRules, ArchetypeService service, ReminderConfiguration config, ActionFactory actionFactory) {
        super(reminderTypes, reminderRules, patientRules, practice, service, config, null, actionFactory);
        this.smsService = smsService;
        this.evaluator = evaluator;
        this.smsEnabled = smsService.isEnabled();
    }

    @Override
    public String getArchetype() {
        return "act.patientReminderItemSMS";
    }

    @Override
    public void process(SMSReminders reminders) {
        if (!this.smsEnabled) {
            throw new ReportingException(ReportingException.ErrorCode.SMSDisabled, new Object[0]);
        }
        String phoneNumber = reminders.getPhoneNumber();
        try {
            int maxParts;
            Party practice = this.getPractice();
            String text = reminders.getText(practice);
            if (StringUtils.isEmpty((CharSequence)text)) {
                throw new ReportingException(ReportingException.ErrorCode.SMSMessageEmpty, reminders.getSMSTemplate().getName());
            }
            int parts = this.smsService.getParts(text);
            if (parts > (maxParts = this.smsService.getMaxParts())) {
                throw new ReportingException(ReportingException.ErrorCode.SMSMessageTooLong, reminders.getSMSTemplate().getName(), parts, maxParts);
            }
            Party patient = null;
            String notes = null;
            String subject = Messages.get((String)"reminder.log.sms.subject");
            ReminderEvent event = reminders.getFirst();
            if (event != null) {
                patient = event.getPatient();
                notes = this.getNote(event);
            }
            this.smsService.send(phoneNumber, text, reminders.getCustomer(), patient, null, subject, "PATIENT_REMINDER", notes, reminders.getLocation());
        }
        catch (OpenVPMSException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new ReportingException(ReportingException.ErrorCode.FailedToProcessReminder, exception, exception.getMessage());
        }
    }

    @Override
    public boolean isAsynchronous() {
        return false;
    }

    @Override
    protected Contact getContact(Party customer, ContactMatcher matcher, Contact defaultContact) {
        Contact contact = super.getContact(customer, matcher, defaultContact);
        if (contact != null && StringUtils.isEmpty((CharSequence)SMSHelper.getPhone((Contact)contact))) {
            contact = null;
        }
        return contact;
    }

    @Override
    protected void log(PatientReminders reminders, CommunicationLogger logger) {
    }

    @Override
    protected void prepare(SMSReminders reminders) {
        super.prepare(reminders);
        DocumentTemplate template = reminders.getTemplate();
        if (template != null && reminders.canSend()) {
            Entity smsTemplate = template.getSMSTemplate();
            if (smsTemplate == null) {
                throw new ReportingException(ReportingException.ErrorCode.TemplateMissingSMSText, template.getName());
            }
            reminders.setSMSTemplate(smsTemplate);
        }
    }

    @Override
    protected ContactMatcher createContactMatcher() {
        return new SMSMatcher("REMINDER", false, (IMObjectBeanFactory)this.getService());
    }

    @Override
    protected String getContactArchetype() {
        return "contact.phoneNumber";
    }

    @Override
    protected SMSReminders createPatientReminders(ReminderType.GroupBy groupBy, boolean resend) {
        return new SMSReminders(groupBy, resend, this.evaluator);
    }
}

