/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.archetype.rules.party.ContactMatcher;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderRules;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.print.IMObjectReportPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.print.InteractivePrinter;
import org.openvpms.web.component.print.PrinterListener;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.customer.communication.CommunicationLogger;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminders;

public class ReminderListProcessor
extends PatientReminderProcessor<PatientReminders> {
    private final Party location;
    private final HelpContext help;
    private final IMPrinterFactory factory;
    private PrinterListener listener;

    public ReminderListProcessor(ReminderTypes reminderTypes, ReminderRules reminderRules, PatientRules patientRules, Party location, Party practice, ArchetypeService service, ReminderConfiguration config, IMPrinterFactory factory, CommunicationLogger logger, ActionFactory actionFactory, HelpContext help) {
        super(reminderTypes, reminderRules, patientRules, practice, service, config, logger, actionFactory);
        this.location = location;
        this.help = help;
        this.factory = factory;
    }

    @Override
    public String getArchetype() {
        return "act.patientReminderItemList";
    }

    @Override
    public void process(PatientReminders reminders) {
        ArrayList<Act> acts = new ArrayList<Act>();
        for (ReminderEvent reminder : reminders.getReminders()) {
            acts.add(reminder.getReminder());
        }
        this.print(acts);
    }

    @Override
    public boolean isAsynchronous() {
        return true;
    }

    public void setListener(PrinterListener listener) {
        this.listener = listener;
    }

    protected void print(List<Act> reminders) {
        LocalContext context = new LocalContext();
        context.setLocation(this.location);
        context.setPractice(this.getPractice());
        ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator("act.patientReminder", (Context)context);
        IMObjectReportPrinter printer = this.factory.createIMObjectReportPrinter(reminders, (DocumentTemplateLocator)locator, (Context)context);
        InteractivePrinter iPrinter = this.createPrinter((IMObjectReportPrinter<Act>)printer, (Context)context);
        iPrinter.setListener(this.listener);
        iPrinter.print();
    }

    @Override
    protected PatientReminders createPatientReminders(ReminderType.GroupBy groupBy, boolean resend) {
        return new PatientReminders(groupBy, resend);
    }

    @Override
    protected void prepare(PatientReminders reminders) {
        for (ReminderEvent reminder : reminders.getReminders()) {
            Party customer = reminder.getCustomer();
            Party location = this.getLocation(customer);
            ContactMatcher matcher = this.createContactMatcher("contact.phoneNumber");
            Contact contact = this.getContact(customer, matcher, reminder.getContact());
            this.populate(reminder, contact, location);
        }
    }

    @Override
    protected void log(PatientReminders reminders, CommunicationLogger logger) {
        String subject = Messages.get((String)"reminder.log.list.subject");
        for (ReminderEvent reminder : reminders.getReminders()) {
            Party customer = reminder.getCustomer();
            Party patient = reminder.getPatient();
            String notes = this.getNote(reminder);
            Party location = reminder.getLocation();
            Contact contact = reminder.getContact();
            String description = contact != null ? contact.getDescription() : "";
            logger.logPhone(customer, patient, description, subject, "PATIENT_REMINDER", null, notes, location);
        }
    }

    protected InteractivePrinter createPrinter(IMObjectReportPrinter<Act> printer, Context context) {
        return this.createPrinter(Messages.get((String)"reporting.reminder.list.print.title"), printer, context, this.help);
    }

    protected InteractivePrinter createPrinter(String title, IMObjectReportPrinter<Act> printer, Context context, HelpContext help) {
        return new InteractiveIMPrinter(title, printer, true, context, help);
    }

    protected PrinterListener getListener() {
        return this.listener;
    }
}

