/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.Iterator;
import org.openvpms.archetype.rules.patient.reminder.GroupingReminderIterator;
import org.openvpms.archetype.rules.patient.reminder.PagedReminderItemIterator;
import org.openvpms.archetype.rules.patient.reminder.ReminderConfiguration;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderGroupingPolicy;
import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderTypes;
import org.openvpms.archetype.rules.patient.reminder.Reminders;
import org.openvpms.component.business.service.archetype.ArchetypeServiceHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IPage;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.workspace.reporting.reminder.ReminderItemSource;

public class ReminderItemQuerySource
implements ReminderItemSource {
    private final ReminderItemQueryFactory factory;
    private final ReminderTypes reminderTypes;
    private final ReminderGroupingPolicy groupByCustomer;
    private final ReminderGroupingPolicy groupByPatient;
    private static final int PAGE_SIZE = 100;

    public ReminderItemQuerySource(ReminderItemQueryFactory factory, ReminderTypes reminderTypes, ReminderConfiguration configuration) {
        this.factory = factory;
        this.reminderTypes = reminderTypes;
        this.groupByCustomer = configuration.getGroupByCustomerPolicy();
        this.groupByPatient = configuration.getGroupByPatientPolicy();
    }

    @Override
    public String[] getArchetypes() {
        return this.factory.getArchetypes();
    }

    @Override
    public Iterator<ReminderEvent> all() {
        return new ObjectSetToReminderEventIterator((Iterator<ObjectSet>)new PagedReminderItemIterator(this.factory, 100, (IArchetypeService)ServiceHelper.getArchetypeService()));
    }

    @Override
    public Iterable<Reminders> query() {
        return new Iterable<Reminders>(){

            @Override
            public Iterator<Reminders> iterator() {
                return new GroupingReminderIterator(ReminderItemQuerySource.this.factory, ReminderItemQuerySource.this.reminderTypes, 100, ReminderItemQuerySource.this.groupByCustomer, ReminderItemQuerySource.this.groupByPatient, (IArchetypeService)ServiceHelper.getArchetypeService());
            }
        };
    }

    @Override
    public int count() {
        ArchetypeQuery query = this.factory.createQuery();
        query.setCountResults(true);
        IArchetypeService service = ArchetypeServiceHelper.getArchetypeService();
        IPage results = service.getObjects((IArchetypeQuery)query);
        return results.getTotalResults();
    }

    private static class ObjectSetToReminderEventIterator
    implements Iterator<ReminderEvent> {
        private final Iterator<ObjectSet> iterator;

        public ObjectSetToReminderEventIterator(Iterator<ObjectSet> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public ReminderEvent next() {
            return new ReminderEvent(this.iterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

