/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import org.openvpms.archetype.rules.patient.reminder.ReminderItemQueryFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderPreviewer;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessor;
import org.openvpms.web.workspace.reporting.reminder.PatientReminderProcessorFactory;
import org.openvpms.web.workspace.reporting.reminder.ReminderEmailPreviewer;
import org.openvpms.web.workspace.reporting.reminder.ReminderEmailProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderExportPreviewer;
import org.openvpms.web.workspace.reporting.reminder.ReminderExportProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderGenerator;
import org.openvpms.web.workspace.reporting.reminder.ReminderListPreviewer;
import org.openvpms.web.workspace.reporting.reminder.ReminderListProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderPrintPreviewer;
import org.openvpms.web.workspace.reporting.reminder.ReminderPrintProcessor;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSPreviewer;
import org.openvpms.web.workspace.reporting.reminder.ReminderSMSProcessor;

public class ReminderGeneratorFactory {
    private final ArchetypeService service;

    public ReminderGeneratorFactory(ArchetypeService service) {
        this.service = service;
    }

    public ReminderGenerator create(Act item, Contact contact, Party location, Party practice, HelpContext help) {
        IMObjectBean bean = this.service.getBean((IMObject)item);
        Act reminder = (Act)bean.getSource("reminder", Act.class);
        if (reminder == null) {
            throw new IllegalArgumentException("Argument 'item' is not associated with any reminder");
        }
        return this.create(item, reminder, contact, location, practice, help);
    }

    public ReminderGenerator create(Act item, Act reminder, Contact contact, Party location, Party practice, HelpContext help) {
        return new ReminderGenerator(item, reminder, contact, help, this.createFactory(location, practice, help));
    }

    public ReminderGenerator create(ReminderItemQueryFactory factory, Party location, Party practice, HelpContext help) {
        return new ReminderGenerator(factory, help, this.createFactory(location, practice, help));
    }

    public PatientReminderProcessorFactory createFactory(Party location, Party practice, HelpContext help) {
        return new PatientReminderProcessorFactory(location, practice, help);
    }

    public PatientReminderPreviewer createPreviewer(PatientReminderProcessor<?> processor, HelpContext help) {
        if (processor instanceof ReminderEmailProcessor) {
            return new ReminderEmailPreviewer((ReminderEmailProcessor)processor, help);
        }
        if (processor instanceof ReminderSMSProcessor) {
            return new ReminderSMSPreviewer((ReminderSMSProcessor)processor, help);
        }
        if (processor instanceof ReminderPrintProcessor) {
            return new ReminderPrintPreviewer((ReminderPrintProcessor)processor, help);
        }
        if (processor instanceof ReminderExportProcessor) {
            return new ReminderExportPreviewer((ReminderExportProcessor)processor, help);
        }
        if (processor instanceof ReminderListProcessor) {
            return new ReminderListPreviewer((ReminderListProcessor)processor, help);
        }
        throw new IllegalArgumentException("Unsupported processor: " + processor.getClass().getName());
    }
}

