/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.workspace.reporting.reminder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.button.AbstractButton;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.archetype.component.processor.BatchProcessor;
import org.openvpms.archetype.rules.patient.reminder.ReminderEvent;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.web.component.im.layout.ComponentGrid;
import org.openvpms.web.component.processor.BatchProcessorTask;
import org.openvpms.web.component.processor.ProgressBarProcessor;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.workspace.reporting.reminder.ReminderBatchProcessor;
import org.openvpms.web.workspace.reporting.reminder.Statistics;

class ReminderGenerationDialog
extends PopupDialog {
    private final WorkflowImpl workflow;
    private final AbstractButton ok;
    private final AbstractButton cancel;

    public ReminderGenerationDialog(List<ReminderBatchProcessor> processors, HelpContext help) {
        super(Messages.get((String)"reporting.reminder.run.title"), "ReminderGenerationDialog.Large", OK_CANCEL, help);
        this.setModal(true);
        this.workflow = new WorkflowImpl(help);
        this.workflow.setBreakOnCancel(false);
        ComponentGrid grid = new ComponentGrid();
        if (processors.size() == 1) {
            this.setStyleName("ReminderGenerationDialog.Small");
        }
        for (ReminderBatchProcessor processor : this.sort(processors)) {
            ReminderBatchProcessorTask task = new ReminderBatchProcessorTask(processor);
            task.setTerminateOnError(false);
            this.workflow.addTask((Task)task);
            Label title = LabelFactory.create(null, (String)"bold");
            title.setText(processor.getTitle());
            SendStats statistics = new SendStats();
            Component component = processor.getComponent();
            if (component == null) {
                component = LabelFactory.create();
            }
            grid.add(new Component[]{title, component, task.getStatus()});
            grid.add(new Component[]{new Label(), LabelFactory.create((String)"reporting.reminder.run.sent"), statistics.getSentComponent()});
            grid.add(new Component[]{new Label(), LabelFactory.create((String)"reporting.reminder.run.errors"), statistics.getErrorComponent()});
            grid.add(new Component[]{new Label(), LabelFactory.create((String)"reporting.reminder.run.cancelled"), statistics.getCancelledComponent()});
            processor.setStatistics(statistics);
        }
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{grid.createGrid()}));
        this.workflow.addTaskListener((TaskListener)new DefaultTaskListener(){

            public void taskEvent(TaskEvent event) {
                ReminderGenerationDialog.this.onGenerationComplete();
            }
        });
        ButtonSet buttons = this.getButtons();
        this.ok = buttons.getButton("ok");
        this.cancel = this.getButtons().getButton("cancel");
        this.ok.setEnabled(false);
        this.cancel.setEnabled(true);
    }

    public void show() {
        super.show();
        this.workflow.start();
    }

    protected void onCancel() {
        String title = Messages.get((String)"reporting.reminder.run.cancel.title");
        String msg = Messages.get((String)"reporting.reminder.run.cancel.message");
        final ConfirmationDialog dialog = new ConfirmationDialog(title, msg, YES_NO);
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent e) {
                if ("yes".equals(dialog.getAction())) {
                    ReminderGenerationDialog.this.workflow.cancel();
                    ReminderGenerationDialog.this.close("cancel");
                } else {
                    ReminderBatchProcessor processor = ReminderGenerationDialog.this.getCurrent();
                    if (processor instanceof ProgressBarProcessor) {
                        processor.process();
                    }
                }
            }
        });
        ReminderBatchProcessor processor = this.getCurrent();
        if (processor instanceof ProgressBarProcessor) {
            ((ProgressBarProcessor)processor).setSuspend(true);
        }
        dialog.show();
    }

    private ReminderBatchProcessor getCurrent() {
        BatchProcessorTask task = (BatchProcessorTask)this.workflow.getCurrent();
        if (task != null) {
            return (ReminderBatchProcessor)task.getProcessor();
        }
        return null;
    }

    private void onGenerationComplete() {
        this.ok.setEnabled(true);
        this.cancel.setEnabled(false);
    }

    protected List<ReminderBatchProcessor> sort(List<ReminderBatchProcessor> processors) {
        ArrayList<ReminderBatchProcessor> result = new ArrayList<ReminderBatchProcessor>(processors);
        Collections.sort(result, new Comparator<ReminderBatchProcessor>(){

            @Override
            public int compare(ReminderBatchProcessor o1, ReminderBatchProcessor o2) {
                return Integer.compare(ReminderGenerationDialog.this.getSortIndex(o1), ReminderGenerationDialog.this.getSortIndex(o2));
            }
        });
        return result;
    }

    private int getSortIndex(ReminderBatchProcessor processor) {
        switch (processor.getArchetype()) {
            case "act.patientReminderItemEmail": {
                return 0;
            }
            case "act.patientReminderItemSMS": {
                return 1;
            }
            case "act.patientReminderItemPrint": {
                return 2;
            }
            case "act.patientReminderItemExport": {
                return 3;
            }
        }
        return 4;
    }

    private static class SendStats
    extends Statistics {
        private final Label sentLabel = this.createLabel();
        private final Label errorLabel = this.createLabel();
        private final Label cancelledLabel = this.createLabel();

        public Label getSentComponent() {
            return this.sentLabel;
        }

        public Label getErrorComponent() {
            return this.errorLabel;
        }

        public Label getCancelledComponent() {
            return this.cancelledLabel;
        }

        @Override
        public void increment(ReminderEvent reminder, ReminderType reminderType) {
            super.increment(reminder, reminderType);
            this.sentLabel.setText(Integer.toString(this.getCount()));
        }

        @Override
        public void addErrors(int errors) {
            super.addErrors(errors);
            this.errorLabel.setText(Integer.toString(this.getErrors()));
        }

        @Override
        public void addCancelled(int cancelled) {
            super.addCancelled(cancelled);
            this.cancelledLabel.setText(Integer.toString(this.getCancelled()));
        }

        private Label createLabel() {
            Label label = new Label();
            label.setLayoutData((LayoutData)ComponentGrid.layout((Alignment)Alignment.ALIGN_RIGHT));
            label.setText("0");
            return label;
        }
    }

    private static class ReminderBatchProcessorTask
    extends BatchProcessorTask {
        private final Label status = LabelFactory.create(null, (String)"bold");

        public ReminderBatchProcessorTask(ReminderBatchProcessor processor) {
            super((BatchProcessor)processor);
        }

        public Label getStatus() {
            return this.status;
        }

        protected void notifyStarting(Task task) {
            super.notifyStarting(task);
            this.status.setText(Messages.get((String)"reporting.reminder.run.running"));
        }

        protected void notifyCompleted() {
            super.notifyCompleted();
            ReminderBatchProcessor processor = (ReminderBatchProcessor)this.getProcessor();
            if (processor.hasMoreReminders()) {
                this.status.setText(Messages.get((String)"reporting.reminder.run.completedmoreavail"));
            } else {
                this.status.setText(Messages.get((String)"reporting.reminder.run.completed"));
            }
        }

        protected void notifyCancelled() {
            super.notifyCancelled();
            this.status.setText(Messages.get((String)"reporting.reminder.run.cancelled"));
        }
    }
}

